/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.cms.portal.util.paging.PagingAspect;
import com.tandbergtv.neptune.realm.conf.IRealmConfigurationService;
import com.tandbergtv.neptune.realm.persist.SearchMetadata;
import com.tandbergtv.neptune.realm.persist.SearchResult;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.usermgmt.ejb.DigestUtil;
import com.tandbergtv.neptune.usermgmt.service.IUserActionCallback;
import com.tandbergtv.neptune.usermgmt.service.IUserAvailabilityService;
import com.tandbergtv.neptune.usermgmt.service.UserActionException;
import com.tandbergtv.neptune.usermgmt.service.internal.IInternalUserManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.aspectj.runtime.internal.AroundClosure;

@Local(value={IInternalUserManager.class})
@Stateless
public class LocalUserManager
implements IInternalUserManager {
    private static final String ID_FIELD_NAME = "id";
    private static final String BUSY_USER_ERROR_CODE = "UserAction-BusyUser";
    private static final Character ESCAPE_CHARACTER = new Character('!');
    @PersistenceContext(unitName="NeptuneRealm")
    protected EntityManager entityManager;
    @EJB
    protected IRealmConfigurationService realmConfiguration;

    @PageTarget(entityClass="User", entityName="user")
    public List<User> getUsers() {
        List list;
        Object[] objectArray = new Object[]{LocalUserManager.class.getDeclaredMethod("getUsers", new Class[0]).getAnnotation(PageTarget.class)};
        PagingAspect.ajc$cflowStack$0.push(objectArray);
        try {
            String string = "SELECT user FROM User user";
            EntityManager entityManager = this.entityManager;
            Query query = PagingAspect.ajc$cflowStack$0.isValid() ? LocalUserManager.createQuery_aroundBody1$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
            list = query.getResultList();
        }
        finally {
            PagingAspect.ajc$cflowStack$0.pop();
        }
        return list;
    }

    public User getUser(UserKey userKey) {
        return this.find(userKey.getId());
    }

    public User getUser(String userName) {
        return this.findByUserName(userName);
    }

    public List<User> getUsersWithPermission(String moduleName, String permissionName) {
        String string = "SELECT user FROM User user, IN(user.roles) role, IN(role.permissions) permission where permission.name = :permissionName and permission.module.name = :moduleName";
        EntityManager entityManager = this.entityManager;
        Query query = PagingAspect.ajc$cflowStack$0.isValid() ? LocalUserManager.createQuery_aroundBody3$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
        query.setParameter("moduleName", (Object)moduleName);
        query.setParameter("permissionName", (Object)permissionName);
        return query.getResultList();
    }

    public User createUser(User user) {
        this.encryptPassword(user);
        this.entityManager.persist((Object)user);
        for (IUserActionCallback callback : this.getUserActionCallbacks()) {
            callback.onCreate(user);
        }
        return user;
    }

    public User updateUser(User user) {
        Query query = this.entityManager.createNamedQuery("User.GetPassword");
        query.setParameter("userId", (Object)user.getId());
        String oldPassword = (String)query.getSingleResult();
        user.setPassword(oldPassword);
        return this.saveUserForUpdate(user);
    }

    public User updateUserWithPassword(User user) {
        this.encryptPassword(user);
        return this.saveUserForUpdate(user);
    }

    private User saveUserForUpdate(User user) {
        User updatedUser = (User)this.entityManager.merge((Object)user);
        for (IUserActionCallback callback : this.getUserActionCallbacks()) {
            callback.onUpdate(updatedUser);
        }
        return updatedUser;
    }

    public boolean deleteUser(UserKey userKey) {
        User user = this.find(userKey.getId());
        if (user == null) {
            return false;
        }
        if (this.isReadOnly(user)) {
            String errorMessage = "The user '" + user.getUserName() + "' is read-only, cannot delete the user.";
            throw new RuntimeException(errorMessage);
        }
        for (IUserActionCallback callback : this.getUserActionCallbacks()) {
            callback.onBeforeDelete(user);
        }
        for (IUserAvailabilityService service : ServiceLoader.load(IUserAvailabilityService.class)) {
            if (!service.isBusy(user.getUserName())) continue;
            String message = "The user '" + user.getUserName() + "' is busy, cannot delete the user.";
            UserActionException e = new UserActionException(BUSY_USER_ERROR_CODE, message);
            e.getParameters().add(user.getUserName());
            throw e;
        }
        this.entityManager.remove((Object)user);
        for (IUserActionCallback callback : this.getUserActionCallbacks()) {
            callback.onDelete(user);
        }
        return true;
    }

    public boolean deleteUsers(UserKey ... userKeys) {
        boolean result = true;
        for (UserKey userKey : userKeys) {
            result &= this.deleteUser(userKey);
        }
        return result;
    }

    public User setActiveStatus(UserKey userKey, boolean active) {
        User user = (User)this.entityManager.find(User.class, (Object)userKey);
        if (user != null) {
            user.setActive(active);
        }
        return user;
    }

    public boolean isReadOnly() {
        return false;
    }

    public boolean isReadOnly(User user) {
        List<UserKey> readOnlyUserKeys = this.realmConfiguration.getReadOnlyUserKeys();
        return user != null && readOnlyUserKeys.contains(user.getUserKey());
    }

    public SearchResult<User> getUsers(SearchMetadata searchCriteria) {
        return this.getSearchResult("user", "", searchCriteria, null);
    }

    public SearchResult<User> getUsers(String userCriteria, SearchMetadata searchCriteria) {
        if (userCriteria == null || userCriteria.trim().length() == 0) {
            return new SearchResult(new ArrayList(), 0);
        }
        String searchString = this.formatCriteria(userCriteria);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("searchString", searchString);
        parameters.put("escapeCharacter", ESCAPE_CHARACTER);
        String alias = "user";
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("WHERE ");
        queryBuf.append("(");
        queryBuf.append("LOWER(").append(alias).append(".").append("userName").append(")");
        queryBuf.append(" LIKE :searchString ESCAPE :escapeCharacter");
        queryBuf.append(" OR ");
        queryBuf.append("LOWER(").append(alias).append(".").append("firstName").append(")");
        queryBuf.append(" LIKE :searchString ESCAPE :escapeCharacter");
        queryBuf.append(" OR ");
        queryBuf.append("LOWER(").append(alias).append(".").append("lastName").append(")");
        queryBuf.append(" LIKE :searchString ESCAPE :escapeCharacter");
        queryBuf.append(")");
        return this.getSearchResult(alias, queryBuf.toString(), searchCriteria, parameters);
    }

    private User find(Long userId) {
        return (User)this.entityManager.find(User.class, (Object)userId);
    }

    private User findByUserName(String userName) {
        User match = null;
        Query query = this.entityManager.createNamedQuery("User.FindByUserName");
        query.setParameter("userName", (Object)userName);
        try {
            match = (User)query.getSingleResult();
        }
        catch (NoResultException nre) {
            match = null;
        }
        return match;
    }

    private void encryptPassword(User user) {
        String encryptedPassword = DigestUtil.Digest(user.getPassword(), "SHA");
        user.setPassword(encryptedPassword);
    }

    private String formatCriteria(String criteria) {
        String searchString = criteria.trim().toLowerCase();
        String pattern = "[" + ESCAPE_CHARACTER + "_%]";
        String replacement = ESCAPE_CHARACTER + "$0";
        searchString = searchString.replaceAll(pattern, replacement);
        searchString = "%" + searchString + "%";
        return searchString;
    }

    private SearchResult<User> getSearchResult(String alias, String searchQuery, SearchMetadata criteria, Map<String, Object> parameters) {
        String queryString = this.buildSelectQueryPart(alias, false) + searchQuery + this.buildSortQueryPart(alias, criteria);
        Query query = this.buildQuery(queryString, parameters);
        this.setPagingCriteria(query, criteria);
        List users = query.getResultList();
        int count = this.getUserCount(alias, searchQuery, parameters);
        return new SearchResult(users, count);
    }

    private String buildSelectQueryPart(String alias, boolean isCount) {
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append("SELECT ");
        if (isCount) {
            queryBuf.append("COUNT(").append(alias).append(")");
        } else {
            queryBuf.append(alias);
        }
        queryBuf.append(" FROM User ").append(alias).append(" ");
        return queryBuf.toString();
    }

    private String buildSortQueryPart(String alias, SearchMetadata criteria) {
        StringBuilder queryBuf = new StringBuilder();
        queryBuf.append(" ORDER BY ");
        if (criteria.getSortField() != null) {
            queryBuf.append(alias).append(".").append(criteria.getSortField());
            queryBuf.append(this.getSortOrder(criteria.getSortOrder()));
        }
        if (!ID_FIELD_NAME.equals(criteria.getSortField())) {
            if (criteria.getSortField() != null) {
                queryBuf.append(", ");
            }
            queryBuf.append(alias).append(".").append(ID_FIELD_NAME);
        }
        return queryBuf.toString();
    }

    private String getSortOrder(SearchMetadata.SortOrder sortOrder) {
        return sortOrder == null || sortOrder.equals((Object)SearchMetadata.SortOrder.Ascending) ? " ASC" : " DESC";
    }

    private Query buildQuery(String queryString, Map<String, Object> parameters) {
        String string = queryString;
        EntityManager entityManager = this.entityManager;
        Query query = PagingAspect.ajc$cflowStack$0.isValid() ? LocalUserManager.createQuery_aroundBody5$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                query.setParameter(key, parameters.get(key));
            }
        }
        return query;
    }

    private void setPagingCriteria(Query query, SearchMetadata searchCriteria) {
        if (searchCriteria.getStartRecord() != null) {
            query.setFirstResult(searchCriteria.getStartRecord().intValue());
        }
        if (searchCriteria.getMaximumRecordCount() != null) {
            query.setMaxResults(searchCriteria.getMaximumRecordCount().intValue());
        }
    }

    private int getUserCount(String alias, String searchQuery, Map<String, Object> parameters) {
        String queryString = this.buildSelectQueryPart(alias, true) + searchQuery;
        Query countQuery = this.buildQuery(queryString, parameters);
        Long count = (Long)countQuery.getSingleResult();
        return count.intValue();
    }

    private ServiceLoader<IUserActionCallback> getUserActionCallbacks() {
        return ServiceLoader.load(IUserActionCallback.class);
    }

    private static final /* synthetic */ Query createQuery_aroundBody1$advice(LocalUserManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }

    private static final /* synthetic */ Query createQuery_aroundBody3$advice(LocalUserManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }

    private static final /* synthetic */ Query createQuery_aroundBody5$advice(LocalUserManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }
}

