/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.networkmanagement.ejb;

import com.tandbergtv.neptune.networkelements.entity.NetworkElement;
import com.tandbergtv.neptune.networkelements.entity.NetworkElementStatus;
import com.tandbergtv.neptune.networkmanagement.ejb.dao.NetworkElementsDAO;
import java.util.List;

public class NetworkElementsManager {
    private static final NetworkElementsManager instance = new NetworkElementsManager();
    protected long lastRefresh = 0L;
    public static final long DEFAULT_REFRESH_FREQUENCY = 60000L;
    protected long refreshFrequency = 0L;
    protected NetworkElementStatus redundancyStatus;
    private List<NetworkElement> clusterElements;

    private NetworkElementsManager() {
    }

    public static NetworkElementsManager getInstance() {
        return instance;
    }

    public NetworkElementStatus getRedundancyStatus() {
        this.fetchData();
        return this.redundancyStatus;
    }

    public List<NetworkElement> getClusterElementsStatus() {
        this.fetchData();
        return this.clusterElements;
    }

    protected void fetchData() {
        if (System.currentTimeMillis() - this.lastRefresh > 60000L) {
            this.refreshData();
        }
    }

    protected void refreshData() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        this.redundancyStatus = dao.getRedundancyStatus();
        this.clusterElements = dao.getClusterElementsStatus();
        this.lastRefresh = System.currentTimeMillis();
    }

    public Boolean failOverNow() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        return dao.failOverNow();
    }

    public void switchAutoFailOverPreference() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        dao.switchAutoFailOverPreference();
        this.refreshData();
    }
}

