/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.networkmanagement.ejb;

import com.tandbergtv.neptune.networkelements.entity.CMSRedundancyStatus;
import com.tandbergtv.neptune.networkelements.entity.DbClusterInstance;
import com.tandbergtv.neptune.networkelements.entity.NetworkElement;
import com.tandbergtv.neptune.networkelements.entity.NetworkElementStatus;
import com.tandbergtv.neptune.networkmanagement.ejb.dao.NetworkElementsDAO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.log4j.Logger;

public class NetworkElementsManager {
    private static final String DB_CLUSTER_PRESENT_SQL_QUERY = "select value  from v$parameter where name = 'cluster_database'";
    private static final Logger logger = Logger.getLogger(NetworkElementsManager.class);
    private static final NetworkElementsManager instance = new NetworkElementsManager();
    protected long lastRefresh = 0L;
    public static final long DEFAULT_REFRESH_FREQUENCY = 60000L;
    protected long refreshFrequency = 0L;
    protected CMSRedundancyStatus redundancyStatus;
    private List<NetworkElement> clusterElements;
    protected EntityManager entityManager;
    private Boolean isDbClusterPresent;

    private NetworkElementsManager() {
    }

    public static NetworkElementsManager getInstance() {
        return instance;
    }

    public CMSRedundancyStatus getRedundancyStatus() {
        this.fetchData();
        return this.redundancyStatus;
    }

    public List<NetworkElement> getClusterElementsStatus() {
        this.fetchData();
        return this.clusterElements;
    }

    protected void fetchDatabaseClusterInstances() {
        if (this.isDbClusterPresent()) {
            Query query = this.entityManager.createNamedQuery("DbClusterInstance.FindAll");
            List dbs = query.getResultList();
            if (this.clusterElements == null) {
                this.clusterElements = new ArrayList<NetworkElement>();
            }
            this.redundancyStatus.setDatabaseClusterStatus(NetworkElementStatus.ACTIVE);
            for (DbClusterInstance db : dbs) {
                NetworkElement ne = new NetworkElement();
                ne.setIp(db.getIpAddress());
                ne.setMode(db.getDatabaseRole());
                ne.setName(db.getDbInstanceName());
                ne.setStatus(NetworkElementStatus.valueOf((int)db.getDbStatus()));
                if (ne.getStatus().isFailed()) {
                    this.redundancyStatus.setDatabaseClusterStatus(NetworkElementStatus.FAILED);
                }
                this.clusterElements.add(ne);
            }
        } else {
            this.redundancyStatus.setDatabaseClusterStatus(NetworkElementStatus.ACTIVE);
        }
    }

    private boolean isDbClusterPresent() {
        if (this.isDbClusterPresent == null) {
            Query nativeQuery = this.entityManager.createNativeQuery(DB_CLUSTER_PRESENT_SQL_QUERY);
            String result = (String)nativeQuery.getSingleResult();
            this.isDbClusterPresent = Boolean.valueOf(result);
            if (!this.isDbClusterPresent.booleanValue()) {
                logger.warn((Object)"Database cluster not present on current setup.");
            }
        }
        return this.isDbClusterPresent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchData() {
        if (System.currentTimeMillis() - this.lastRefresh > 60000L) {
            NetworkElementsManager networkElementsManager = this;
            synchronized (networkElementsManager) {
                if (System.currentTimeMillis() - this.lastRefresh > 60000L) {
                    this.refreshData();
                }
            }
        }
    }

    protected void refreshData() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        this.redundancyStatus = new CMSRedundancyStatus();
        this.redundancyStatus.setAppServerClusterStatus(dao.getRedundancyStatus());
        this.clusterElements = dao.getClusterElementsStatus();
        this.fetchDatabaseClusterInstances();
        this.lastRefresh = System.currentTimeMillis();
    }

    public Boolean failOverNow() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        return dao.failOverNow();
    }

    public void switchAutoFailOverPreference() {
        NetworkElementsDAO dao = new NetworkElementsDAO();
        dao.switchAutoFailOverPreference();
        this.refreshData();
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

