/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.networkmanagement.ejb;

import com.tandbergtv.neptune.configuration.service.ILifecycleConfigurationService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.networkelements.entity.CMSRedundancyStatus;
import com.tandbergtv.neptune.networkelements.entity.NetworkElement;
import com.tandbergtv.neptune.networkelements.service.INetworkElementsService;
import com.tandbergtv.neptune.networkmanagement.ejb.NetworkElementsManager;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.networkelements.service.INetworkElementsService")
@Local(value={INetworkElementsService.class})
public class NetworkElementsService
implements INetworkElementsService,
ILifecycleConfigurationService {
    private static final String HA_LICENSE = "HALicense";
    @EJB
    private ILicenseManager neptuneLicenseManager;
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    private static Boolean isHighAvailabilityModuleLicensed = null;

    @Override
    public void start() throws Exception {
    }

    private NetworkElementsManager getNetworkElementsManager() {
        NetworkElementsManager manager = NetworkElementsManager.getInstance();
        manager.setEntityManager(this.entityManager);
        return manager;
    }

    public CMSRedundancyStatus getRedundancyStatus() {
        return this.getNetworkElementsManager().getRedundancyStatus();
    }

    public List<NetworkElement> getClusterElementsStatus() {
        return this.getNetworkElementsManager().getClusterElementsStatus();
    }

    public Boolean failOverNow() {
        return this.getNetworkElementsManager().failOverNow();
    }

    public void switchAutoFailOverPreference() {
        this.getNetworkElementsManager().switchAutoFailOverPreference();
    }

    public Boolean isHighAvailabilityModuleLicensed() {
        if (isHighAvailabilityModuleLicensed == null) {
            try {
                String value = this.neptuneLicenseManager.getProperty(HA_LICENSE);
                isHighAvailabilityModuleLicensed = value == null || value.trim().isEmpty() ? Boolean.valueOf(false) : Boolean.valueOf(Boolean.parseBoolean(value));
            }
            catch (InvalidLicenseException e) {
                isHighAvailabilityModuleLicensed = false;
            }
        }
        return isHighAvailabilityModuleLicensed;
    }
}

