/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.authentication.login;

import com.tandbergtv.neptune.authentication.entity.IAuthenticationResponse;
import com.tandbergtv.neptune.authentication.entity.IRole;
import com.tandbergtv.neptune.authentication.entity.IUser;
import com.tandbergtv.neptune.authentication.service.IAuthenticationService;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Logger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.client.SecurityClient;
import org.jboss.security.client.SecurityClientFactory;

public class NeptuneLoginModule
extends UsernamePasswordLoginModule {
    private static final Logger logger = Logger.getLogger(NeptuneLoginModule.class);
    private static final String UNAUTHENTICATED_IDENTITY = "_nobody_";
    private static final String AUTH_SERVICE_KEY = "authenticationService";
    private static final String AUTH_SERVICE = "/cms/AuthenticationService/local";
    protected transient IAuthenticationResponse response = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.response = null;
        if (this.unauthenticatedIdentity == null) {
            try {
                this.unauthenticatedIdentity = this.createIdentity(UNAUTHENTICATED_IDENTITY);
            }
            catch (Exception e) {
                String msg = "Failure creating the required unauthenticated identity: " + e.getMessage();
                logger.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
        }
    }

    protected String getUsersPassword() throws LoginException {
        return "";
    }

    protected boolean validatePassword(String password, String expectedPassword) {
        return this.authenticateUserSecure(password);
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup group = new SimpleGroup("Roles");
        try {
            IUser user;
            IUser iUser = user = this.response != null ? this.response.getAuthenticatedUser() : null;
            if (user != null) {
                Set roles = user.getRoles();
                for (IRole role : roles) {
                    group.addMember(super.createIdentity(role.getName()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("Failure getting the roles for user: " + this.getUsername()), (Throwable)e);
            throw new LoginException("Failed to get the list of user roles: " + e.getMessage());
        }
        return new Group[]{group};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateUserSecure(String password) {
        logger.debug((Object)("Attempting to securely login user: " + this.getUsername()));
        this.response = null;
        boolean authenticated = false;
        try {
            SecurityClient securityClient = SecurityClientFactory.getSecurityClient();
            securityClient.setSimple(null, null);
            securityClient.login();
            try {
                authenticated = this.authenticateUser(password);
                logger.debug((Object)("Secure login for User: " + this.getUsername() + " has " + (authenticated ? "succeeded." : "failed.")));
            }
            finally {
                try {
                    securityClient.logout();
                }
                catch (Exception e) {
                    String msg = "Failure when ending secure context for calling authentication service.";
                    logger.warn((Object)msg, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            String msg = "Failed to obtain secured context before calling authentication service.";
            logger.error((Object)msg, (Throwable)e);
        }
        return authenticated;
    }

    private boolean authenticateUser(String password) {
        this.response = null;
        boolean authenticated = false;
        try {
            String userName = this.getUsername();
            IAuthenticationService authService = this.getAuthenticationService();
            this.response = authService.authenticateUser(userName, password);
            authenticated = this.response.isAuthenticationSuccessful();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to authenticate user using neptune authentication service.", (Throwable)e);
            authenticated = false;
        }
        return authenticated;
    }

    private IAuthenticationService getAuthenticationService() {
        IAuthenticationService authenticationService = null;
        try {
            String jndiName = this.getAuthenticationServiceJNDIName();
            InitialContext context = new InitialContext();
            authenticationService = (IAuthenticationService)context.lookup(jndiName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to call neptune authentication service.", e);
        }
        return authenticationService;
    }

    private String getAuthenticationServiceJNDIName() {
        String value = (String)this.options.get(AUTH_SERVICE_KEY);
        if (value == null || value.trim().length() == 0) {
            value = AUTH_SERVICE;
        }
        return value;
    }
}

