/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.internal;

import com.tandbergtv.neptune.usermgmt.internal.DataSourceProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class ConnectionManager {
    private static final Logger logger = Logger.getLogger((String)ConnectionManager.class.getName());
    private static final ThreadLocal<Map<String, Connection>> CONNECTIONS = new ThreadLocal();
    private final String dataSourceName;

    public ConnectionManager(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public boolean isCurrentConnectionActive() {
        return this.isConnectionActive(this.getConnection());
    }

    public Connection getCurrentConnection() throws SQLException {
        Connection connection = this.getConnection();
        if (!this.isConnectionActive(connection)) {
            DataSource dataSource = DataSourceProvider.getDataSource(this.dataSourceName);
            connection = dataSource.getConnection();
            connection.setReadOnly(true);
            this.putConnection(connection);
        }
        return connection;
    }

    public void closeCurrentConnection() {
        Connection connection = this.getConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.warn((Object)("Error closing database connection from data source[" + this.dataSourceName + "]: " + e.getLocalizedMessage()), (Throwable)e);
            }
            this.removeConnection();
        }
    }

    public void closeSQLStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                logger.warn((Object)("Error closing SQL statement: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    private Connection getConnection() {
        Map<String, Connection> connectionMap = CONNECTIONS.get();
        return connectionMap != null ? connectionMap.get(this.dataSourceName) : null;
    }

    private void putConnection(Connection connection) {
        Map<String, Connection> connectionMap = CONNECTIONS.get();
        if (connectionMap == null) {
            connectionMap = new HashMap<String, Connection>();
            CONNECTIONS.set(connectionMap);
        }
        connectionMap.put(this.dataSourceName, connection);
    }

    private void removeConnection() {
        Map<String, Connection> connectionMap = CONNECTIONS.get();
        if (connectionMap != null) {
            connectionMap.remove(this.dataSourceName);
            if (connectionMap.isEmpty()) {
                CONNECTIONS.remove();
            }
        }
    }

    private boolean isConnectionActive(Connection connection) {
        return connection != null;
    }
}

