/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.persist;

import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.UserKey;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="CMS_USER", uniqueConstraints={@UniqueConstraint(columnNames={"USERNAME"})})
@NamedQueries(value={@NamedQuery(name="User.FindByUserName", query="SELECT user FROM User user WHERE user.userName = :userName"), @NamedQuery(name="User.FindAll", query="SELECT user FROM User user ORDER BY user.userName"), @NamedQuery(name="User.GetPassword", query="SELECT user.password FROM User user WHERE user.id = :userId")})
public class User
implements Serializable,
Comparable<User> {
    private static final long serialVersionUID = -4271492741128343502L;
    private Long id;
    private String externalKey;
    private String userName;
    private String password;
    private Date passwordModifiedDate;
    private boolean active = true;
    private String firstName;
    private String lastName;
    private String email;
    private String phone;
    private String extension;
    private String employeeId;
    private String department;
    private String location;
    private Set<Role> roles = new HashSet<Role>();

    @Id
    @Column(name="USERID")
    @SequenceGenerator(name="UserID Sequence Generator", sequenceName="CMS_USER_SEQ", allocationSize=20)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="UserID Sequence Generator")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Transient
    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    @Transient
    public UserKey getUserKey() {
        return new UserKey(this.id, this.externalKey);
    }

    public void setUserKey(UserKey userKey) {
        this.setId(userKey != null ? userKey.getId() : null);
        this.setExternalKey(userKey != null ? userKey.getExternalKey() : null);
    }

    @Column(name="USERNAME", unique=true, nullable=false)
    @Basic(optional=false)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name="PASSWORD", nullable=false)
    @Basic(optional=false)
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name="PASSWORDMODIFIEDDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getPasswordModifiedDate() {
        return this.passwordModifiedDate;
    }

    public void setPasswordModifiedDate(Date passwordModifiedDate) {
        this.passwordModifiedDate = passwordModifiedDate;
    }

    @Column(name="ACTIVE", nullable=false)
    @Basic(optional=false)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="FIRSTNAME")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="EMAIL")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="PHONE")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Column(name="EXTENSION")
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Column(name="EMPLOYEEID")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    @Column(name="DEPARTMENT")
    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    @Column(name="LOCATION")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @ManyToMany
    @JoinTable(name="CMS_USERROLES", joinColumns={@JoinColumn(name="USERID", nullable=false)}, inverseJoinColumns={@JoinColumn(name="ROLEID", nullable=false)})
    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        if (roles == null) {
            roles = new HashSet<Role>();
        }
        this.roles = roles;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = this.id == null ? super.hashCode() : this.id.hashCode() * 7 + 129;
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        if (this.id == null && other.id == null) {
            return super.equals(obj);
        }
        return this.id.equals(other.id);
    }

    @Override
    public int compareTo(User u) {
        if (this.userName != null) {
            if (u.userName != null) {
                return this.userName.compareTo(u.userName);
            }
            return -1;
        }
        return 0;
    }
}

