package com.tandbergtv.neptune.ui.realm.client;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleTableProvider;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserTableProvider;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.SingletonWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;

public class RealmComponent extends ComponentBase {
	public List<PortletFactory> listPortlets(final NeptuneSecurity security) {
		return null;
	}

	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
		if (security.isUserInRole("UserManagement_View")
				|| security.isUserInRole("RoleManagement_View")) {
			List<MenuItemBase> adminGroup = new ArrayList<MenuItemBase>();
			if (security.isUserInRole("UserManagement_View")) {
				final UserTableProvider tableProvider = new UserTableProvider(eventSink, eventListenerRegistry, security);
				final SimpleContainer tableContainer = new SimpleContainer();
				final WidgetMenuItem panel = new WidgetMenuItem("User",
						new SingletonWidgetFactory(tableContainer), tableProvider.getAnchorChangeListener());
				tableContainer.add(tableProvider.getTable(panel.getReverseAnchorChangeListener()));
				adminGroup.add(panel);
			}
			if (security.isUserInRole("RoleManagement_View")) {
				final RoleTableProvider tableProvider = new RoleTableProvider(eventSink, eventListenerRegistry, security);
				final SimpleContainer tableContainer = new SimpleContainer();
				final WidgetMenuItem panel = new WidgetMenuItem("Role",
						new SingletonWidgetFactory(tableContainer), tableProvider.getAnchorChangeListener());
				tableContainer.add(tableProvider.getTable(panel.getReverseAnchorChangeListener()));
				adminGroup.add(panel);		
			}
			tabs.add(new GroupMenuItem("Admin", adminGroup));
		}
		return tabs;
	}

	public <E extends Service> List<E> listServices(Class<E> clazz,
			NeptuneSecurity security) {
		return new ArrayList<E>();
	}

}
