package com.tandbergtv.neptune.ui.realm.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.BeanUtils;

import com.tandbergtv.cms.portal.util.paging.PageSource;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUser;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserKey;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UiUserList;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserNotFoundException;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserUiService;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.validation.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;

//@TransactionAttribute(TransactionAttributeType.REQUIRES_NEW)
public class UserUiServiceImpl implements UserUiService, NeptuneRemoteService {
	private static final long serialVersionUID = 1L;

	private IUserManager inner = InjectionUtil.injectInstance("cms/UserManager/local", IUserManager.class);

	@Override
	public String getRelativePath() {
		return "service/realm/userService";
	}

	@Override
	public Class<?> getServiceImplementation() {
		return getClass();
	}

	@Override
	@PageSource
	@Transactional
	public UiUserList listUsers(int startIndex, int endIndex, String sortByProperty, boolean isAscending) {
		final List<UiUser> uUsers = new ArrayList<UiUser>();
		final List<User> bUsers = inner.getUsers();
		for (User bUser : bUsers) {
			UiUser uUser = new UiUser();
			copyProperties(bUser, uUser);
			uUsers.add(uUser);
		}
		UiUserList userList = new UiUserList(uUsers, uUsers.size());
		return userList;
	}

	private void copyProperties(User bUser, UiUser uUser) {
		BeanUtils.copyProperties(bUser, uUser);
		// uUser.setPassword(null);
		Set<Role> roles = bUser.getRoles();
		Set<UiRoleKey> roleIds = new HashSet<UiRoleKey>();
		for (Role role : roles) {
			roleIds.add(new UiRoleKey(role.getId(), role.getExternalKey()));
		}
		uUser.setRoleIds(roleIds);
	}

	private void copyProperties(UiUser uUser, User bUser) {
		BeanUtils.copyProperties(uUser, bUser);
		if (bUser.getPasswordModifiedDate() == null)
			bUser.setPasswordModifiedDate(new Date());
		Set<UiRoleKey> roleIds = uUser.getRoleIds();
		Set<Role> roles = new HashSet<Role>();
		for (UiRoleKey roleId : roleIds) {
			Role role = new Role();
			role.setId(roleId.getId());
			role.setExternalKey(roleId.getExternalKey());
			roles.add(role);
		}
		bUser.setRoles(roles);
	}

	@Override
	@Transactional
	public void deleteUsers(List<UiUserKey> userIds) {
		for (UiUserKey userId : userIds)
			inner.deleteUser(new UserKey(userId.getId(), userId.getExternalKey()));
	}

	@Override
	@Transactional
	public UiUser getUser(UiUserKey userId) throws UserNotFoundException {
		UiUser uUser = new UiUser();
		User bUser = inner.getUser(new UserKey(userId.getId(), userId.getExternalKey()));
		if(bUser == null)
			throw new UserNotFoundException();
		copyProperties(bUser, uUser);
		return uUser;
	}

	@Override
	@Transactional
	public UiUserKey saveUser(UiUser uUser) throws NeptuneException {
		User bUser = new User();
		copyProperties(uUser, bUser);
		try {
			if (bUser.getId() == null)
				bUser = inner.createUser(bUser);
			else {
				if (uUser.isChangePassword())
					inner.updateUserWithPassword(bUser);
				else
					inner.updateUser(bUser);
			}
		} catch(ValidationException e) {
			throw new com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException(
					e.getValidationMessages());
		}
		return new UiUserKey(bUser.getId(), bUser.getExternalKey());
	}

	@Override
	@Transactional
	public UiUser getUser(String userName) throws UserNotFoundException {
		UiUser uUser = new UiUser();
		User bUser = inner.getUser(userName);
		if(bUser == null)
			throw new UserNotFoundException();
		copyProperties(bUser, uUser);
		return uUser;
	}
}
