package com.tandbergtv.neptune.ui.realm.client.tab.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.realm.client.event.RoleAddedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.RoleDeletedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.RoleUpdatedEvent;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleUiService;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleUiServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleList;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListener;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

public final class UserDataProvider implements DataProvider<UiUserKey, UserRecord> {
	private final List<Column<?, UserRecord>> columns;
	final ColumnBase<String, UserRecord> usernameColumn;
	final ColumnBase<String, UserRecord> firstNameColumn;
	final ColumnBase<String, UserRecord> lastNameColumn;

	private final UserUiServiceAsync userService = GWT.create(UserUiService.class);
	private final RoleUiServiceAsync roleService = GWT.create(RoleUiService.class);

	private final EventListenerRegistry eventListenerRegistry;
	private final NeptuneSecurity security;
	private PageFeatureImpl<UiUserKey, UserRecord> pageFeature;
	private SortFeatureImpl<UiUserKey, UserRecord> sortFeature;
	
	private List<UiRole> roles;
	private final Collection<RoleListener> roleListeners = new ArrayList<RoleListener>();

	public UserDataProvider(EventListenerRegistry eventListenerRegistry, NeptuneSecurity security) {
		this.eventListenerRegistry = eventListenerRegistry;
		this.security = security;
		
		columns = new ArrayList<Column<?, UserRecord>>();

		usernameColumn = new ColumnBase<String, UserRecord>("userName", "User Name") {
			public View<String> getView(UserRecord record) {
				return new LabelStringView(record.getUser().getUserName());
			}
		};
		columns.add(usernameColumn);

		firstNameColumn = new ColumnBase<String, UserRecord>("firstName", "First Name") {
			public View<String> getView(UserRecord record) {
				return new LabelStringView(record.getUser().getFirstName());
			}
		};
		columns.add(firstNameColumn);
		lastNameColumn = new ColumnBase<String, UserRecord>("lastName", "Last Name") {
			public View<String> getView(UserRecord record) {
				return new LabelStringView(record.getUser().getLastName());
			}
		};
		columns.add(lastNameColumn);
	}

	public void setPageFeature(PageFeatureImpl<UiUserKey, UserRecord> pageFeature) {
		this.pageFeature = pageFeature;
	}

	public void setSortFeature(SortFeatureImpl<UiUserKey, UserRecord> sortFeature) {
		this.sortFeature = sortFeature;
	}

	public void addRoleListener(RoleListener roleListener) {
		roleListeners.add(roleListener);
	}

	public void removeRoleListener(RoleListener roleListener) {
		roleListeners.remove(roleListener);
	}

	public void initialize(final AsyncCallback<Void> callback) {
		roleService.listRoles(0, 1000, "name", true, new NeptuneAsyncCallback<UiRoleList>() {

			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			public void onNeptuneSuccess(UiRoleList result) {
				roles = new ArrayList<UiRole>(result.getRoles());
				eventListenerRegistry.registerEventListener(RoleAddedEvent.class, new EventListener<RoleAddedEvent>() {
					public void eventOccured(RoleAddedEvent event) {
						roles.add(event.getRole());
						for (RoleListener roleListener : roleListeners)
							roleListener.roleAdded(event.getRole());
					}
				});
				eventListenerRegistry.registerEventListener(RoleDeletedEvent.class, new EventListener<RoleDeletedEvent>() {
					public void eventOccured(RoleDeletedEvent event) {
						roles.remove(event.getRole());
						for (RoleListener roleListener : roleListeners)
							roleListener.roleDeleted(event.getRole());
					}
				});
				eventListenerRegistry.registerEventListener(RoleUpdatedEvent.class, new EventListener<RoleUpdatedEvent>() {
					public void eventOccured(RoleUpdatedEvent event) {
						int index = roles.indexOf(event.getRole());
						if(index == -1) {
							roles.add(event.getRole());
						} else {
							roles.remove(index);
							roles.add(index, event.getRole());
						}
						for (RoleListener roleListener : roleListeners)
							roleListener.roleUpdated(event.getRole());
					}
				});
				callback.onSuccess(null);
			}
		});
	}

	public List<Column<?, UserRecord>> getColumns() {
		return columns;
	}

	public List<UiRole> getRoles() {
		return roles;
	}

	public void getRecord(UiUserKey key, final AsyncCallback<UserRecord> callback) {
		userService.getUser(key, new NeptuneAsyncCallback<UiUser>() {
			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			public void onNeptuneSuccess(UiUser result) {
				callback.onSuccess(new UserRecord(result));
			}
		});
	}

	public void getRecords(final AsyncCallback<List<UserRecord>> callback) {
		userService.listUsers(pageFeature.getStart(), pageFeature.getLength(), sortFeature.getSortColumnName(),
				sortFeature.isAscending(), new NeptuneAsyncCallback<UiUserList>() {

					public void onNeptuneFailure(Throwable caught) {
						Window.alert(caught.getMessage());
						callback.onFailure(caught);
					}

					public void onNeptuneSuccess(UiUserList result) {
						List<UserRecord> records = new ArrayList<UserRecord>();
						for (UiUser user : result.getUsers())
							records.add(new UserRecord(user));
						pageFeature.setTotalSize(result.getTotal());
						callback.onSuccess(records);
					}
				});

	}

	public boolean isCheckboxEnabled() {
		return security.isUserInRole(UserTableProvider.DELETE_PERMISSION);
	}

	public boolean isRecordCountEnabled() {
		return true;
	}

}