package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeatureImpl;

public class UserTableProvider {
	private final UserDataProvider dataProvider;
	private final PageFeatureImpl<UiUserKey, UserRecord> pageFeature;
	private final SortFeatureImpl<UiUserKey, UserRecord> sortFeature;
	private final BookmarkFeatureImpl<UiUserKey, UserRecord> bookmarkFeature;
	private final UserDetailFeature detailFeature;

	private final Table<UiUserKey, UserRecord> table;
	
	static String VIEW_PERMISSION = "UserManagement_View";
	static String CREATE_PERMISSION = "UserManagement_Create";
	static String MODIFY_PERMISSION = "UserManagement_Modify";
	static String DELETE_PERMISSION = "UserManagement_Delete";

	public UserTableProvider(EventSink eventSink, EventListenerRegistry eventListenerRegistry, NeptuneSecurity security) {
		dataProvider = new UserDataProvider(eventListenerRegistry, security);
		table = new Table<UiUserKey, UserRecord>(dataProvider);

		pageFeature = new PageFeatureImpl<UiUserKey, UserRecord>(table);
		detailFeature = new UserDetailFeature(dataProvider, eventSink, security);
		sortFeature = new SortFeatureImpl<UiUserKey, UserRecord>(dataProvider.usernameColumn, SortOrder.ASCENDING);
		bookmarkFeature = new UserBookmarkFeatureImpl(table, new KeySerializer<UiUserKey>() {
			public UiUserKey fromString(String keyString) {
				return UiUserKey.parse(keyString);
			}

			public String toString(UiUserKey key) {
				return key.toString();
			}
		});
		sortFeature.addSortableColumn(dataProvider.usernameColumn);
		sortFeature.addSortableColumn(dataProvider.firstNameColumn);
		sortFeature.addSortableColumn(dataProvider.lastNameColumn);
		
		dataProvider.setPageFeature(pageFeature);
		dataProvider.setSortFeature(sortFeature);
	}

	public Table<?, ?> getTable(AnchorChangeListener reverseListener) {
		bookmarkFeature.addDetailFeature(reverseListener, table, dataProvider, detailFeature);
		bookmarkFeature.addPageFeature(reverseListener, table, pageFeature);

		table.addDetailFeature(detailFeature);
		table.addSortFeature(sortFeature);
		table.addPageFeature(pageFeature);
		table.addBookmarkFeature(bookmarkFeature);
		
		return table;
	}

	public AnchorChangeListener getAnchorChangeListener() {
		return new AnchorChangeListener() {
			public void anchorChanged(final String anchor) {
				table.init(new AsyncCallback<Void>() {
					@Override
					public void onFailure(Throwable caught) {
					}

					@Override
					public void onSuccess(Void result) {
						bookmarkFeature.anchorChanged(anchor);
					}});
			}
		};
	}
}
