package com.tandbergtv.neptune.ui.realm.client.tab.user;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.framework.client.i18n.NeptuneConstants;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleKey;
import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class UserRecordDetailView implements DetailView<UiUserKey, UserRecord>, RoleListener {
	private static final String STYLE_VALIDATION_MESSAGE = "realm-validationFailure-message";
	
	private final UserRecord record;
	private UserDataProvider dataProvider;

	private final TextBoxWidget usernameBox = new TextBoxWidget();
	private final TextBoxWidget passwordTextBox = new TextBoxWidget();
	private final Map<UiRoleKey, UiRole> keyToRoleMap = new HashMap<UiRoleKey, UiRole>();
	private final ListBoxWidget<UiRole> rolesListBox = new ListBoxWidget<UiRole>();
	private final TextBoxWidget firstNameTextBox = new TextBoxWidget();
	private final TextBoxWidget lastNameTextBox = new TextBoxWidget();
	private final CheckBoxWidget isActiveCheckBox = new CheckBoxWidget("", false);
	private final TextBoxWidget emailTextBox = new TextBoxWidget();
	private final TextBoxWidget employeeIdTextBox = new TextBoxWidget();
	private final TextBoxWidget departmentTextBox = new TextBoxWidget();
	private final TextBoxWidget locationTextBox = new TextBoxWidget();
	private final TextBoxWidget phoneTextBox = new TextBoxWidget();
	private final TextBoxWidget extTextBox = new TextBoxWidget();
	private final LabelWidget errorMessageLabel = new LabelWidget(); 
	private final FormContainer formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);

	private final VerticalContainer headerAndMainContainer = new VerticalContainer();
	
	private NeptuneConstants constants = GWT.create(NeptuneConstants.class);
	ButtonWidget saveButton, revertButton;
	
	public UserRecordDetailView(final UserRecord record, final UserDataProvider dataProvider,
			final DetailViewCallback<UiUserKey, UserRecord> callback) {
		this.record = record;
		this.dataProvider = dataProvider;
		
		errorMessageLabel.setStyleName(STYLE_VALIDATION_MESSAGE);

		/* Add a null default entry in the role list box */
		rolesListBox.addItem("", null);

		usernameBox.setReadOnly(record.getUser().getKey().isValueAssigned());
		dataProvider.addRoleListener(this);

		// invoke it now to build the initial list of roles
		for (UiRole role : dataProvider.getRoles())
			roleAdded(role);

		formContainer.addRow("User Name:", usernameBox, true);
		//password field is required while creating and not editing
		formContainer.addRow("Password:", passwordTextBox, !record.getUser().getKey().isValueAssigned());
		formContainer.addRow("Roles:", rolesListBox, true);
		formContainer.addRow("First Name:", firstNameTextBox, true);
		formContainer.addRow("Last Name:", lastNameTextBox, true);
		formContainer.addRow("Is Active?:", isActiveCheckBox);
		formContainer.addRow("Email:", emailTextBox, true);
		formContainer.addRow("Employee ID:", employeeIdTextBox, true);
		formContainer.addRow("Department:", departmentTextBox, true);
		formContainer.addRow("Location:", locationTextBox, true);
		formContainer.addRow("Phone:", phoneTextBox);
		formContainer.addRow("Extension:", extTextBox);

		// make the form buttons call back the table
		
		saveButton = new ButtonWidget("Save", new ClickHandler() {
			public void onClick(ClickEvent event) {
				errorMessageLabel.setText(null);
				callback.save(UserRecordDetailView.this);
			}
		});
		saveButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		formContainer.addButton(saveButton);
		
		ButtonWidget cancelButton = new ButtonWidget("Cancel", new ClickHandler() {
			public void onClick(ClickEvent event) {
				errorMessageLabel.setText(null);
				callback.cancel(UserRecordDetailView.this);
			}
		});
		cancelButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		formContainer.addButton(cancelButton);
		
		revertButton = new ButtonWidget("Revert", new ClickHandler() {
			public void onClick(ClickEvent event) {
				errorMessageLabel.setText(null);
				callback.revert(UserRecordDetailView.this);
			}
		});
		revertButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
		formContainer.addButton(revertButton);
		
		revert();
	}

	public void setSaveAllowed(boolean allowed) {
		saveButton.setVisible(allowed);
		revertButton.setVisible(allowed);
	}
	
	public void roleAdded(UiRole role) {
		rolesListBox.addItem(role.getName(), role);
		keyToRoleMap.put(role.getKey(), role);
	}

	public void roleDeleted(UiRole role) {
		rolesListBox.removeItem(role);
		keyToRoleMap.remove(role.getKey());
	}

	public void roleUpdated(UiRole role) {
		/* Update the role at its current index */
		int index = rolesListBox.getIndex(role);
		if (index == -1) {
			rolesListBox.addItem(role.getName(), role);
		} else {
			rolesListBox.setItem(role.getName(), role, index);
		}
	}
	
	public void commit() {
		record.getUser().setUserName(usernameBox.getText());
		if ((passwordTextBox.getText() != null && passwordTextBox.getText().trim().length() > 0)) {
			record.getUser().setChangePassword(true);
			record.getUser().setPasswordModifiedDate(new Date());
			record.getUser().setPassword(passwordTextBox.getText().trim());
		}

		/* Get selected Role IDs */
		final HashSet<UiRoleKey> roleIds = new HashSet<UiRoleKey>();
		for (int index = 0; index < rolesListBox.getItemCount(); index++) {
			if (rolesListBox.isItemSelected(index)) {
				UiRole role = rolesListBox.getItem(index);
				if (role != null) {
					roleIds.add(role.getKey());
				}
			}
		}

		record.getUser().setRoleIds(roleIds);
		record.getUser().setFirstName(firstNameTextBox.getText());
		record.getUser().setLastName(lastNameTextBox.getText());
		record.getUser().setActive(isActiveCheckBox.getValue());
		record.getUser().setEmail(emailTextBox.getText());
		record.getUser().setEmployeeId(employeeIdTextBox.getText());
		record.getUser().setDepartment(departmentTextBox.getText());
		record.getUser().setLocation(locationTextBox.getText());
		record.getUser().setPhone(phoneTextBox.getText());
		record.getUser().setExtension(extTextBox.getText());
	}

	@Override
	public Widget getWidget() {
		String userName = record.getUser().getUserName();
		if(userName == null) {
			userName = "";
		}
		headerAndMainContainer.add(new HeaderPanel(constants.userDetails() + " " + userName));
		headerAndMainContainer.add(errorMessageLabel);
		headerAndMainContainer.add(formContainer);
		return headerAndMainContainer;
	}

	public void revert() {
		usernameBox.setText(record.getUser().getUserName());
		passwordTextBox.setText("");
		final Set<UiRoleKey> roleIds = record.getUser().getRoleIds();
		rolesListBox.setSelectedIndex(-1);
		for (UiRoleKey key : roleIds) {
			int index = rolesListBox.getIndex(keyToRoleMap.get(key));
			rolesListBox.setItemSelected(index, true);
		}
		firstNameTextBox.setText(record.getUser().getFirstName());
		lastNameTextBox.setText(record.getUser().getLastName());
		isActiveCheckBox.setValue(record.getUser().isActive());
		emailTextBox.setText(record.getUser().getEmail());
		employeeIdTextBox.setText(record.getUser().getEmployeeId());
		departmentTextBox.setText(record.getUser().getDepartment());
		locationTextBox.setText(record.getUser().getLocation());
		phoneTextBox.setText(record.getUser().getPhone());
		extTextBox.setText(record.getUser().getExtension());
	}

	public void release() {
		dataProvider.removeRoleListener(this);
	}

	public UserRecord getRecord() {
		return record;
	}

	public String getStyleName() {
	    return null;
	}

	@Override
	public void saveFailed(Throwable throwable) {
		if(throwable instanceof ValidationException) {
			ValidationException ve = (ValidationException) throwable;
			StringBuffer messagesSB = new StringBuffer();
			for(String message : ve.getValidationMessages()) {
				messagesSB.append(message).append("\n");
			}
			errorMessageLabel.setText(messagesSB.toString());
		} else {
			errorMessageLabel.setText(throwable.getLocalizedMessage());
		}
	}
	
}