/*
 * Created on Jan 25, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.ui.framework.client.application;

import java.util.List;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.home.client.HomeTabPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

/**
 * Factory used to create the Home Tab Panel widget
 * 
 * @author Vijay Silva
 */
public class HomeTabPanelFactory implements WidgetFactory {

	/* State */
	private NeptuneSecurity security;
	private List<PortletFactory> portletFactories;

	/**
	 * Constructor
	 * 
	 * @param security The security
	 * @param portletFactories The list of portlets to show in the home tab
	 */
	public HomeTabPanelFactory(NeptuneSecurity security, List<PortletFactory> portletFactories) {
		this.security = security;
		this.portletFactories = portletFactories;
	}

	/**
	 * Creates a new instance of the HomeTabPanel widget
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.application.TypedWidgetFactory#getInstance()
	 */
	@Override
	public Widget getInstance() {
		return new HomeTabPanel(security, portletFactories);
	}

	@Override
	public void release(Widget widget) {
	}
}
