package com.tandbergtv.neptune.ui.framework.client.impl;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class ServiceLoaderImpl implements ServiceLoader {
	private final List<Component> components;
	private final NeptuneSecurity security;
	
	public ServiceLoaderImpl(List<Component> components, NeptuneSecurity security)
	{
		this.components = components;
		this.security = security;
	}
	
	public <E extends Service> List<E> loadServices(
			Class<E> serviceInterface) {
		List<E> services = new ArrayList<E>();
		for (Component component : components) {
			List<E> serviceList = component.listServices(serviceInterface,
					security);
			if (serviceList != null)
				services.addAll(serviceList);
		}
		return services;
	}
}
