package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.CookieStoreBasedPageFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

public class UserTableProvider {

	private final UserDataProvider dataProvider;
	private final CookieStoreBasedPageFeatureImpl pageFeature;
	private final SortFeatureImpl<UiUserKey, UserRecord> sortFeature;
	private final BookmarkFeatureImpl bookmarkFeature;
	private final UserDetailFeature detailFeature;
	private final AnchorChangeListener anchorChangeListener;

	private final Table<UiUserKey, UserRecord> table;
	
	static String VIEW_PERMISSION = "UserManagement_View";
	static String CREATE_PERMISSION = "UserManagement_Create";
	static String MODIFY_PERMISSION = "UserManagement_Modify";
	static String DELETE_PERMISSION = "UserManagement_Delete";

	public UserTableProvider(EventSink eventSink, EventListenerRegistry eventListenerRegistry, NeptuneSecurity security) {
		dataProvider = new UserDataProvider(eventListenerRegistry, security);
		table = new Table<UiUserKey, UserRecord>(dataProvider);

		pageFeature = new CookieStoreBasedPageFeatureImpl("userList");
		detailFeature = new UserDetailFeature(dataProvider, eventSink, security);
		sortFeature = new SortFeatureImpl<UiUserKey, UserRecord>(dataProvider.usernameColumn, SortOrder.ASCENDING);
		bookmarkFeature = new BookmarkFeatureImpl();
		sortFeature.addSortableColumn(dataProvider.usernameColumn);
		sortFeature.addSortableColumn(dataProvider.firstNameColumn);
		sortFeature.addSortableColumn(dataProvider.lastNameColumn);

		dataProvider.setPageFeature(pageFeature);
		dataProvider.setSortFeature(sortFeature);

		table.addDetailFeature(detailFeature);
		table.addSortFeature(sortFeature);
		table.addPageFeature(pageFeature);
		table.addBookmarkFeature(bookmarkFeature);
		
		anchorChangeListener = new UserMenuAnchorChangeListener(this);
	}

	/**
	 * Set the anchor change notifier for the table
	 * 
	 * @param anchorChangeNotifier The anchor change notifier
	 */
	public void setAnchorChangeNotifier(AnchorChangeListener anchorChangeNotifier) {
		table.setAnchorChangeNotifier(anchorChangeNotifier);
	}
	
	/**
	 * Get the table
	 * 
	 * @return The table
	 */
	public Table<UiUserKey, UserRecord> getTable() {
		return table;
	}

	public AnchorChangeListener getAnchorChangeListener() {
		return this.anchorChangeListener;
	}
}
