package com.tandbergtv.neptune.ui.realm.client.tab.role;

import java.util.ArrayList;
import java.util.Collection;

import com.google.gwt.user.client.rpc.IsSerializable;

public class UiRole implements IsSerializable {
	UiRoleKey key = new UiRoleKey();
	private String name;
	private Collection<Long> permissionIds = new ArrayList<Long>(0);
	private String description;
	private Integer userCount;
	private boolean readOnly;

	public Long getId() {
		return key.getId();
	}

	public void setId(Long id) {
		this.key.setId(id);
	}

	public String getExternalKey() {
		return key.getExternalKey();
	}

	public void setExternalKey(String externalKey) {
		this.key.setExternalKey(externalKey);
	}

	public UiRoleKey getKey() {
		return key;
	}

	public void setKey(UiRoleKey key) {
		if (key == null)
			key = new UiRoleKey();

		this.key = key;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getUserCount() {
		return userCount;
	}

	public void setUserCount(Integer userCount) {
		this.userCount = userCount;
	}

	public Collection<Long> getPermissionIds() {
		return permissionIds;
	}

	public void setPermissionIds(Collection<Long> permissionIds) {
		this.permissionIds = permissionIds;
	}

	/**
	 * @return the readOnly
	 */
	public boolean isReadOnly() {
		return readOnly;
	}

	/**
	 * @param readOnly the readOnly to set
	 */
	public void setReadOnly(boolean readOnly) {
		this.readOnly = readOnly;
	}

	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return key.hashCode() + 71;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof UiRole))
			return false;
		UiRole other = (UiRole) obj;
		return key.equals(other.key);
	}
}
