package com.tandbergtv.neptune.ui.realm.client.tab.user;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

@RemoteServiceRelativePath("service/realm/userService")
public interface UserUiService extends RemoteService {

	UiUserList listUsers(int startIndex, int endIndex, String sortByProperty, boolean isAscending)
			throws NeptuneException;

	void deleteUsers(List<UiUserKey> userKeys) throws NeptuneException, UserDeletionException;

	UiUser getUser(UiUserKey userKey) throws NeptuneException, UserNotFoundException;
	
	UiUser getUser(String userName) throws NeptuneException, UserNotFoundException;

	UiUserKey saveUser(UiUser user) throws NeptuneException;

	public static class Util {

		public static UserUiServiceAsync getInstance() {

			return GWT.create(UserUiService.class);
		}
	}
}
