package com.tandbergtv.neptune.ui.home.client;

import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * The Add Portlet page responsible for adding portlets to the Home page
 * 
 * @author Daniel Paranhos
 */
public class AddPortletPanel extends VerticalContainer {

    private static final String CONTAINER_PANEL_STYLE_LIST = "headerAndTableListPanel";
    private static final String STYLE_VALIDATION_MESSAGE = "realm-validationFailure-message";
    private RealmConstants constants = GWT.create( RealmConstants.class );

    private final Table<String, PortletRecord> table;
    private final PortletDataProvider portletDataProvider;
    private final LabelWidget errorMessageLabel;
    private final HomeTabPanel homeTabPanel;

    /**
     * Constructor
     * 
     * @param homeTabPanel
     *            the HomeTabPanel
     * @param portletFactories
     *            the list of all portlet factories
     */
    public AddPortletPanel( final HomeTabPanel homeTabPanel, List<PortletFactory> portletFactories ) {
        this.homeTabPanel = homeTabPanel;
        homeTabPanel.showBusyIndicator();

        setStyleName( CONTAINER_PANEL_STYLE_LIST );
        setSpacing( 5 );

        errorMessageLabel = new LabelWidget();
        errorMessageLabel.setStyleName( STYLE_VALIDATION_MESSAGE );
        add( errorMessageLabel );

        add( new HeaderPanel( "Add Portlet" ) );
        portletDataProvider = new PortletDataProvider( portletFactories );
        table = new Table<String, PortletRecord>( portletDataProvider );
        table.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
                errorMessageLabel.setText( constants.couldNotLoadData() );
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
                init( homeTabPanel );
                refresh();
            }
        } );

    }

    private void init( final HomeTabPanel homeTabPanel ) {
        add( table );
        ButtonWidget addButton = new ButtonWidget();
        addButton.setText( "Add" );
        addButton.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                if ( table.getSelectedRecords().size() > 0 ) {
                    for ( PortletRecord portletRecord : table.getSelectedRecords() ) {
                        homeTabPanel.addPortlet( portletRecord.getPortlet() );
                    }
                    homeTabPanel.saveCurrentState( new NeptuneAsyncCallback<Void>() {

                        @Override
                        public void onNeptuneFailure( Throwable caught ) {
                            errorMessageLabel.setText( constants.errorAddPortlets() );
                        }

                        @Override
                        public void onNeptuneSuccess( Void result ) {
                            homeTabPanel.initPortal();
                        }
                    } );
                } else {
                    Window.alert( constants.portletSelectionRequired() );
                }

            }
        } );

        ButtonWidget backButton = new ButtonWidget();
        backButton.setText( "Back" );
        backButton.addClickHandler( new ClickHandler() {

            @Override
            public void onClick( ClickEvent event ) {
                homeTabPanel.initPortal();
            }
        } );
        HorizontalPanel buttonsPanel = new HorizontalPanel();
        buttonsPanel.setSpacing( 5 );

        buttonsPanel.add( addButton );
        buttonsPanel.add( backButton );

        add( buttonsPanel );
    }

    /**
     * Refreshes the data
     */
    public void refresh() {
        homeTabPanel.showBusyIndicator();
        errorMessageLabel.setText( null );
        table.getRecords().clear();
        portletDataProvider.initialize( new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure( Throwable caught ) {
                errorMessageLabel.setText( constants.couldNotLoadData() );
                homeTabPanel.hideBusyIndicator();
            }

            @Override
            public void onNeptuneSuccess( Void result ) {
                table.refresh();
                homeTabPanel.hideBusyIndicator();
            }
        } );
    }

}
