package com.tandbergtv.neptune.ui.home.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.realm.client.tab.userpref.UiUserPreference;
import com.tandbergtv.neptune.ui.realm.client.tab.userpref.UserPreferenceService;
import com.tandbergtv.neptune.ui.realm.client.tab.userpref.UserPreferenceServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

/**
 * The data provider for the Home Portal
 * 
 * @author Daniel Paranhos
 */
public class PortletDataProvider implements DataProvider<String, PortletRecord> {
    private final List<Column<?, PortletRecord>> columns;
    private final ColumnBase<String, PortletRecord> componentColumn;
    private final ColumnBase<String, PortletRecord> titleColumn;

    private List<PortletFactory> portletFactories;
    private List<UiUserPreference> uiUserPreferencesList;

    private final UserPreferenceServiceAsync userPreferenceService = GWT.create( UserPreferenceService.class );

    /**
     * Constructor
     * @param portletFactories the list of all portlet factories
     */
    public PortletDataProvider( List<PortletFactory> portletFactories ) {
        this.portletFactories = portletFactories;

        columns = new ArrayList<Column<?, PortletRecord>>();

        componentColumn = new ColumnBase<String, PortletRecord>( "component", "Component" ) {
            public View<String> getView( PortletRecord record ) {
                return new LabelStringView( record.getComponent() );
            }
        };
        columns.add( componentColumn );

        titleColumn = new ColumnBase<String, PortletRecord>( "title", "Title" ) {
            public View<String> getView( PortletRecord record ) {
                return new LabelStringView( record.getPortlet().getDisplayName() );
            }
        };
        columns.add( titleColumn );

    }

    public void initialize( final AsyncCallback<Void> callback ) {
        userPreferenceService.getPreferences( HomeTabPanel.HOME_COMPONENT, HomeTabPanel.PORTLET_ORDER_TYPE, 
            new NeptuneAsyncCallback<List<UiUserPreference>>() {

                public void onNeptuneFailure( Throwable caught ) {
                    callback.onFailure( caught );
                }
    
                public void onNeptuneSuccess( List<UiUserPreference> result ) {
                    uiUserPreferencesList = new ArrayList<UiUserPreference>();
                    uiUserPreferencesList.addAll( result );
                    callback.onSuccess( null );
                }
            } 
        );
    }

    public List<Column<?, PortletRecord>> getColumns() {
        return columns;
    }

    public void getRecord( String key, final AsyncCallback<PortletRecord> callback ) {
        // not needed to implement this method. There is no detail page
    }

    public void getRecords( final AsyncCallback<List<PortletRecord>> callback ) {
        List<PortletRecord> portletRecordsList = new ArrayList<PortletRecord>();
        for ( PortletFactory portletFactory : portletFactories ) {
            if ( !isPortletAdded( portletFactory.getInstance() ) ) {
                portletRecordsList.add( createPortletRecord( portletFactory ) );                
            }
        }
        
        Collections.sort( portletRecordsList, new Comparator<PortletRecord>() {
            @Override
            public int compare( PortletRecord pr1, PortletRecord pr2 ) {
                int result = pr1.getComponent().compareTo( pr2.getComponent() );
                if ( result == 0 ) {
                    result = pr1.getPortlet().getDisplayName().compareTo( pr2.getPortlet().getDisplayName() );
                }
                return result;
            }
        } );

        callback.onSuccess( portletRecordsList );
    }
    
    private boolean isPortletAdded( Portlet portlet ) {
        boolean added = false;
        for ( UiUserPreference uiUserPreference : uiUserPreferencesList ) {
            if ( portlet.getId().equals( uiUserPreference.getKey() ) ) {
                added = true;
                break;
            }
        }
        
        return added;
    }
    
    private PortletRecord createPortletRecord( PortletFactory portletFactory ) {
        PortletRecord portletRecord = new PortletRecord( portletFactory.getInstance() );
        portletRecord.setComponent( portletFactory.getComponent().getDisplayName() );
        
        return portletRecord;
    }

    public boolean isCheckboxEnabled() {
        return true;
    }

    public boolean isRecordCountEnabled() {
        return false;
    }
}
