package com.tandbergtv.neptune.ui.realm.client.tab.userpref;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * The User Preferences Management Service that provides functionality to manage 
 * application user preferences.
 * 
 * @author Daniel Paranhos
 */
@RemoteServiceRelativePath("service/realm/userPreferenceService")
public interface UserPreferenceService extends RemoteService {
    
    /**
     * Creates a User Preference based on the given parameter
     * 
     * @param uiUserPreference the User Preference
     * @return the created User Preference
     */
    UiUserPreference create(UiUserPreference uiUserPreference) throws NeptuneException;
    
    /**
     * Creates User Preferences based on the given list parameter
     * 
     * @param uiUserPreferences the list of User Preferences
     * @return the list of created User Preferences
     */
    List<UiUserPreference> create(List<UiUserPreference> uiUserPreferences) throws NeptuneException;

    /**
     * Saves the given User Preference
     * 
     * @param uiUserPreference the User Preference
     * @return the saved User Preference
     */
    UiUserPreference save(UiUserPreference uiUserPreference) throws NeptuneException;

    /**
     * Retrieves the User Preference with the given id
     * 
     * @param id the User Preference id
     * @return the User Preference found or null if not found
     */
    UiUserPreference getPreference(Long id) throws NeptuneException;

    /**
     * Retrieves a list of User Preferences with the given component
     * 
     * @param component the component name
     * @return the list of User Preferences found
     */
    List<UiUserPreference> getPreferences(String component) throws NeptuneException;

    /**
     * Retrieves a list of User Preferences with the given component and type
     * 
     * @param component the component name
     * @param type the User Preference type
     * @return the list of User Preferences found
     */
    List<UiUserPreference> getPreferences(String component, String type) throws NeptuneException;

    /**
     * Retrieve the User Preference with the given component, type and key
     * 
     * @param component the component name
     * @param type the User Preference type
     * @param key the User Preference key
     * @return the User Preference found or null if not found
     */
    UiUserPreference getPreference(String component, String type, String key) throws NeptuneException;

    /**
     * Deletes the User Preference with the given id
     * 
     * @param id the User Preference id
     */
    void deletePreference(Long id) throws UserPreferenceDeletionException;

    /**
     * Deletes the User Preferences with the given component
     * 
     * @param component the component name
     */
    void deletePreferences(String component) throws UserPreferenceDeletionException;

    /**
     * Deletes the User Preferences with the given component and type
     * 
     * @param component the component name
     * @param type the User Preference type
     */
    void deletePreferences(String component, String type) throws UserPreferenceDeletionException;

    /**
     * Delete the User Preference with the given component, type and key
     * 
     * @param component the component name
     * @param type the User Preference type
     * @param key the User Preference key
     */
    void deletePreference(String component, String type, String key) throws UserPreferenceDeletionException;
}
