package com.tandbergtv.neptune.ui.realm.client.tab.role;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.ui.framework.client.i18n.NeptuneConstants;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleTableProvider.RoleRecord;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class RoleListPanel extends VerticalContainer {
	private static final String CONTAINER_PANEL_STYLE_LIST = "headerAndTableListPanel";
	private static final String CONTAINER_PANEL_STYLE_DETAIL = "headerAndTableDetailPanel";

	private NeptuneConstants constants = GWT.create(NeptuneConstants.class);
	private RoleTableProvider tableProvider;
	
	public RoleListPanel(EventSink eventSink, EventListenerRegistry eventListenerRegistry) {
		setStyleName(CONTAINER_PANEL_STYLE_LIST);
		setSpacing(5);
		
		final HeaderPanel header = new HeaderPanel("");
		/*
		 * hack to not show the header when the table is loading
		 * consequence:
		 *  set the header visible again and again during list-detail view change,
		 *  when it is actually visible 
		 */
		header.setVisible(false);
		add(header);

		tableProvider = new RoleTableProvider(eventSink, eventListenerRegistry);
		tableProvider.getTable().addTableViewChangeHandler(new TableViewChangeHandler<UiRoleKey, RoleTableProvider.RoleRecord>() {
			@Override
			public void onShowDetailView(
					TableDetailViewEvent<UiRoleKey, RoleRecord> event) {
				setStyleName(CONTAINER_PANEL_STYLE_DETAIL);
				if(event.isCreateView())
					header.setLabel(constants.createRoleHeading());
				else
					header.setLabel(constants.viewEditRoleHeading()
							+ " " + event.getRecord().getRole().getName());
				header.setVisible(true);
			}

			@Override
			public void onShowListView(TableViewEvent event) {
				setStyleName(CONTAINER_PANEL_STYLE_LIST);
				header.setLabel(constants.listRolesHeading());
				header.setVisible(true);
			}});
				
		add(tableProvider.getTable());
	}

	public RoleTableProvider getTableProvider() {
		return tableProvider;
	}

	public void setTableProvider(RoleTableProvider tableProvider) {
		this.tableProvider = tableProvider;
	}
	
	public void setAnchorChangeNotifier(AnchorChangeListener anchorChangeListener) {
		tableProvider.setAnchorChangeNotifier(anchorChangeListener);
	}
}
