package com.tandbergtv.neptune.ui.home.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.dd.DragData;
import com.gwtext.client.dd.DragSource;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.portal.Portal;
import com.gwtext.client.widgets.portal.PortalColumn;
import com.gwtext.client.widgets.portal.PortalDropZone;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;

class HomeTabPortal extends Portal {

	/* Style */
	private static final String STYLE_PORTAL = "home-HomeTabPanel-portal";
	private static final String STYLE_PORTAL_COLUMN = "home-HomeTabPanel-portalColumn";

	private final HomeTabPanel parentPanel;
	private PortalColumn[] columns;

	/* Constructor */
	public HomeTabPortal(HomeTabPanel parentPanel) {
		this.parentPanel = parentPanel;

		/* Create the portal */
		this.setBorder(true);
		this.addClass(STYLE_PORTAL);

		/* Add the portal columns */
		columns = new PortalColumn[2];
		for (int i = 0; i < columns.length; i++) {
			this.columns[i] = createPortalColumn();
			this.add(this.columns[i], new ColumnLayoutData(.5));
		}
	}

	/*
	 * Create a new portal column
	 */
	private PortalColumn createPortalColumn() {
		PortalColumn column = new PortalColumn();
		column.addClass(STYLE_PORTAL_COLUMN);
		column.setAutoDestroy(false);
		return column;
	}

	@Override
	protected void onAttach() {
		doLayout();
		super.onAttach();
	}

	@Override
	protected void onLoad() {
		super.onLoad();

		List<Portlet> portlets = new ArrayList<Portlet>();
		for (PortalColumn column : this.columns) {
			findAllPortlets(column, portlets);
		}

		for (Portlet portlet : portlets) {
			portlet.fireEvent(new DocumentAttachEvent());
		}
	}

	@Override
	protected void onUnload() {
		List<Portlet> portlets = new ArrayList<Portlet>();
		for (PortalColumn column : this.columns) {
			findAllPortlets(column, portlets);
		}

		for (Portlet portlet : portlets) {
			portlet.fireEvent(new DocumentDetachEvent());
		}

		super.onUnload();
	}

	@SuppressWarnings("unchecked")
    @Override
	public Iterator<Widget> iterator() {
	    return super.iterator();
	}
	
	/*
	 * Find all components in the top level container
	 */
	private void findAllPortlets(PortalColumn column, List<Portlet> portlets) {
		Component[] components = column.getComponents();
		if (components != null) {
			for (Component component : components) {
				if (component instanceof Portlet) {
					portlets.add((Portlet) component);
				}
			}
		}
	}

	/**
	 * Show the portlet in the next available location
	 * 
	 * @param portlet The portlet to show
	 */
	public void showPortlet(Portlet portlet) {
		showPortlet(portlet, getColumn());
	}

	/**
	 * Show portlet using the given display index to determine the location
	 * 
	 * @param portlet The portlet to display
	 * @param displayIndex The index to display the portlet at
	 */
	public void showPortlet(Portlet portlet, int displayIndex) {
		showPortlet(portlet, getColumn(displayIndex));
	}

	/*
	 * Show the portlet in the specified column
	 */
	private void showPortlet(Portlet portlet, PortalColumn column) {
		/* Add the portlet to the portal column */
		column.add(portlet);

		/* Simulate the document attachment event if required */
		if (this.isAttached()) {
			portlet.fireEvent(new DocumentAttachEvent());
			doLayout();
		}
	}

	/*
	 * Determine the column to use to display the portlet
	 */
	private PortalColumn getColumn(int displayIndex) {
		int columnCount = this.columns.length;
		int index = (displayIndex % columnCount);
		if (index < 0)
			index += columnCount;
		return this.columns[index];
	}

	/*
	 * Determine the column to use to display the portlet
	 */
	private PortalColumn getColumn() {
		/* Select first column by default */
		PortalColumn column = this.columns[0];
		int minimumSize = getColumnSize(column);

		for (int i = 1; i < this.columns.length; i++) {
			int size = getColumnSize(columns[i]);
			if (size < minimumSize) {
				minimumSize = size;
				column = this.columns[i];
			}
		}

		return column;
	}

	/*
	 * Determine the number of widgets shown in a column
	 */
	private int getColumnSize(PortalColumn column) {
		Component[] components = column.getComponents();
		return (components != null) ? components.length : 0;
	}

	/**
	 * Determine if the portlet is showing
	 * 
	 * @return true if the portlet is being displayed
	 */
	public boolean isPortletShowing(Portlet portlet) {
		for (PortalColumn column : this.columns) {
			if (isPortletShowing(portlet, column)) {
				return true;
			}
		}

		return false;
	}

	/*
	 * Check if the portlet is part of the column
	 */
	private boolean isPortletShowing(Portlet portlet, PortalColumn column) {
		Component[] components = column.getComponents();
		if (components != null) {
			for (Component component : components) {
				if (portlet.equals(component))
					return true;
			}
		}

		return false;
	}

	/**
	 * Remove the portlet from the portal.
	 * 
	 * @return true if the portlet was removed, false if the portlet was not being displayed
	 */
	public boolean removePortlet(Portlet portlet) {
		PortalColumn matchedColumn = null;

		/* Find the column */
		for (PortalColumn column : this.columns) {
			if (isPortletShowing(portlet, column)) {
				matchedColumn = column;
				break;
			}
		}

		/* No matching column */
		if (matchedColumn == null)
			return false;

		matchedColumn.remove(portlet, false);
		portlet.getElement().removeFromParent();

		/* Fire the detach event if required */
		if (this.isAttached()) {
			portlet.fireEvent(new DocumentDetachEvent());
			doLayout();
		}

		return true;
	}

	/**
	 * Get a map of the display index to the portlet
	 * 
	 * @return the map
	 */
	public Map<Integer, Portlet> getPortletIndexMap() {
		Map<Integer, Portlet> portletMap = new HashMap<Integer, Portlet>();
		List<Portlet> portletList = new ArrayList<Portlet>();
		for (int columnIndex = 0; columnIndex < this.columns.length; columnIndex++) {
			findAllPortlets(columns[columnIndex], portletList);
			int index = 0;
			for (Portlet portlet : portletList) {
				int displayIndex = (index * columns.length) + columnIndex;
				portletMap.put(displayIndex, portlet);
				index++;
			}
			portletList.clear();
		}

		return portletMap;
	}

	private void handlePortletDragDrop() {
		/* Notify the parent that the portlet ordering has changed */
		parentPanel.updatePortletOrder();
	}

	@Override
	protected void afterRender() {
		new HomeTabPortalDropZone(this);
	}

	/*
	 * Internal class to provide portlet drop notifications
	 */
	private static final class HomeTabPortalDropZone extends PortalDropZone {
		private HomeTabPortal portal;

		/* Constructor */
		public HomeTabPortalDropZone(HomeTabPortal portal) {
			super(portal, null);
			this.portal = portal;
		}

		/* Handle drop notification */
		@Override
		public boolean notifyDrop(DragSource source, EventObject e, DragData data) {
			boolean dropped = super.notifyDrop(source, e, data);
			if (dropped) {
				portal.handlePortletDragDrop();
			}

			return dropped;
		}
	}
}
