package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;


public interface TableExternal<K, R extends Record<K>> {

	/**
	 * This method must be called after all features have been installed and
	 * before this table is added to a container.
	 */
	void init();

	/**
	 * Informs the table that it should revert to its initial state. This call
	 * will cascade to all installed features as well.
	 */
	void revertToInitialState();

	/**
	 * Reloads data from server.
	 */
	void refresh();
}
