package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

import java.util.HashMap;
import java.util.Map;

import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.TableInternal;

public class BookmarkFeatureImpl<K, R extends Record<K>> implements BookmarkFeature, AnchorChangeListener {
	private final KeySerializer<K> keySerializer;
	private Command editCommand;
	private Command listCommand;
	private final Command reinitCommand;

	public BookmarkFeatureImpl(final TableInternal<K, R> tableInternal, final KeySerializer<K> keySerializer) {
		this.keySerializer = keySerializer;
		reinitCommand = new Command() {
			public void execute(String myAnchor) {
				tableInternal.revertToInitialState();
			}
		};
	}

	public void addPageFeature(final AnchorChangeListener anchorListener, final TableInternal<K, R> tableInternal,
			final PageFeature pageFeature) {
		pageFeature.registerListener(new PageFeature.Listener() {
			public void pagingUpdated(int start, int length) {
				anchorListener.anchorChanged(new StringBuilder().append("?start=").append(start).append("&length=")
						.append(length).toString());
			}
		});
		listCommand = new Command() {
			public void execute(String myAnchor) {
				Map<String, String> map = formParamMap(myAnchor);
				pageFeature.setStart(Integer.parseInt(map.get("start")));
				pageFeature.setLength(Integer.parseInt(map.get("length")));
				tableInternal.setListView();
				tableInternal.refresh();
			}
		};

	}

	public void addDetailFeature(final AnchorChangeListener anchorListener, final TableInternal<K, R> tableInternal,
			final DataProvider<K, R> dataProvider, final DetailFeature<K, R> detailFeature) {
		detailFeature.registerListener(new DetailFeature.Listener<K, R>() {
			public void detailViewShown(DetailView<K, R> detailView) {
				anchorListener.anchorChanged(new StringBuilder().append("Edit?id=").append(
						keySerializer.toString(detailView.getRecord().getKey())).toString());
			}
		});

		editCommand = new Command() {
			public void execute(String myAnchor) {
				K key = keySerializer.fromString(myAnchor.substring(3));
				dataProvider.getRecord(key, new NeptuneAsyncCallback<R>() {
					public void onNeptuneFailure(Throwable caught) {
						Window.alert(caught.getLocalizedMessage());
					}

					public void onNeptuneSuccess(R result) {
						tableInternal.showRecord(result);
					}
				});
			}
		};
	}

	public void anchorChanged(String anchor) {
		// remove the prefix, since its page specific, what follows generic to
		// all tables
		if (anchor.length() == 0) {
			reinitCommand.execute(anchor);
			return;
		}
		if (anchor.startsWith("Edit?")) {
			String myAnchor = anchor.substring(5);
			editCommand.execute(myAnchor);
		}
		else {
			listCommand.execute(anchor);
		}

	}

	private interface Command {
		void execute(String myAnchor);
	}

	private Map<String, String> formParamMap(String paramString) {
		Map<String, String> params = new HashMap<String, String>();
		if (paramString.startsWith("?"))
			paramString = paramString.substring(1);

		String[] splitParamString = paramString.split("&");
		for (String paramFrag : splitParamString) {
			String[] paramSides = paramFrag.split("=");
			params.put(paramSides[0], paramSides[1]);
		}

		return params;
	}

}
