package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;

public interface DetailFeature<K, R extends Record<K>> {
	public interface DetailViewCallback<K, R extends Record<K>> {
		public void save(DetailView<K, R> view);

		public void revert(DetailView<K, R> view);

		public void cancel(DetailView<K, R> view);
	}

	public interface Listener<K, R extends Record<K>> {
		void detailViewShown(DetailView<K, R> detailView);
	}

	void registerListener(Listener<K, R> listener);

	DetailView<K, R> getView(R record, DetailViewCallback<K, R> callback);

	boolean hasDetailLink(Column<?, R> column);

	void getNew(AsyncCallback<R> callback);

	void save(R record, AsyncCallback<Void> callback);

	void delete(List<R> records, AsyncCallback<Void> callback);
	
	boolean showCreateButton();
	
	boolean showDeleteButton();
}
