package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;

public class SortFeatureHandler<K, R extends Record<K>> implements TableConstants, FeatureHandler {
	private final TableInternal<K, R> simpleTable;
	private final SortFeature<K, R> sortFeature;

	public SortFeatureHandler(DataProvider<K, R> dataProvider, TableInternal<K, R> simpleTable,
			SortFeature<K, R> sortFeature) {
		this.simpleTable = simpleTable;
		this.sortFeature = sortFeature;
		reload();
	}

	public void init() {
		sortFeature.setSortColumn(sortFeature.getDefaultSortColumn());
		sortFeature.setSortOrder(sortFeature.getDefaultSortOrder());
		for (final Column<?, R> column : simpleTable.listVisibleColumns()) {
			if (sortFeature.isColumnSortable(column)) {
				if (column.equals(sortFeature.getSortColumn())) {
					Image img = (sortFeature.getSortOrder() == SortOrder.ASCENDING) ? IMAGE_UP_ARROW : IMAGE_DOWN_ARROW;

					simpleTable.getHeaderColPanelForColumn(column).add(img);
				}
				final Label headerLabel = simpleTable.getHeaderLabelForColumn(column);
				headerLabel.setStyleName(STYLE_HEADER_SORTABLE_COL_TEXT);
				headerLabel.addClickHandler(new ClickHandler() {
					public void onClick(ClickEvent event) {
						final HorizontalPanel oldSortColumn = simpleTable.getHeaderColPanelForColumn(sortFeature
								.getSortColumn());
						if (oldSortColumn.getWidgetCount() > 1)
							oldSortColumn.remove(1);
						if (sortFeature.getSortColumn().equals(column)) {
							// inverse the sort order
							sortFeature
									.setSortOrder(sortFeature.getSortOrder().equals(SortOrder.ASCENDING) ? SortOrder.DESCENDING
											: SortOrder.ASCENDING);
						} else {
							// set the default sort order
							sortFeature.setSortOrder(sortFeature.getDefaultSortOrder());
						}
						sortFeature.setSortColumn(column);
						Image img = (sortFeature.getSortOrder() == SortOrder.ASCENDING) ? IMAGE_UP_ARROW
								: IMAGE_DOWN_ARROW;

						simpleTable.getHeaderColPanelForColumn(column).add(img);
						simpleTable.refresh();
					}
				});

			}
		}
	}

	public void reload() {
		sortFeature.setSortColumn(sortFeature.getDefaultSortColumn());
		sortFeature.setSortOrder(sortFeature.getDefaultSortOrder());
	}

}
