package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import java.util.List;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

public class DetailFeatureHandler<K, R extends Record<K>> implements TableConstants, FeatureHandler {
	private DetailView<K, R> currentDetailView;
	private DetailViewRequester<K, R> requester;

	public interface DetailViewRequester<K, R extends Record<K>> {
		void showCreatePage();
		void showDetailViewForRecord(R record);
	}

	public DetailFeatureHandler(final DataProvider<K, R> dataProvider, final TableInternal<K, R> simpleTable,
			final DetailFeature<K, R> detailFeature) {

		if(detailFeature.showCreateButton()) {
			ButtonWidget createButton = new ButtonWidget("Create", new ClickHandler() {
				public void onClick(ClickEvent event) {
					detailFeature.getNew(new AsyncCallback<R>() {
						public void onFailure(Throwable caught) {
							Window.alert(caught.getLocalizedMessage());
						}
	
						public void onSuccess(R result) {
							getDetailView(simpleTable, detailFeature, result);
						}
					});
				}
			});
			createButton.addStyleDependentName(StyleNames.ACTION_BUTTON_STYLE);
			simpleTable.registerWidgetOnActionContainer(createButton);
		}
		
		if(detailFeature.showDeleteButton()) {
			ButtonWidget deleteButton = new ButtonWidget("Delete", new ClickHandler() {
				public void onClick(ClickEvent event) {
					detailFeature.delete(simpleTable.getSelectedRecords(), new NeptuneAsyncCallback<Void>() {
						public void onNeptuneFailure(Throwable caught) {
							Window.alert(caught.getLocalizedMessage());
						}
	
						public void onNeptuneSuccess(Void result) {
							simpleTable.refresh();
						}
					});
				}
			});
			deleteButton.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
			simpleTable.registerWidgetOnActionContainer(deleteButton);
		}

		TableInternal.Listener<K, R> listener = new TableInternal.Listener<K, R>() {
			public void recordsUpdated() {
				for (Column<?, R> column : simpleTable.listVisibleColumns()) {
					if (detailFeature.hasDetailLink(column)) {
						final List<Widget> widgetList = simpleTable.listWidgetsForVisibleColumn(column);
						if (widgetList == null)
							continue;

						for (Widget widget : widgetList) {
							((Label) widget).addClickHandler(new ClickHandler() {
								public void onClick(ClickEvent event) {
									Widget sender = (Widget) event.getSource();
									final R record = simpleTable.getRecordForWidget(sender);
									getDetailView(simpleTable, detailFeature, record);
								}
							});
							widget.setStyleName(STYLE_DATA_LINK);
						}
					}
				}
			}
		};

		requester = new DetailViewRequester<K, R>() {
			@Override
			public void showCreatePage() {
				detailFeature.getNew(new AsyncCallback<R>() {
					public void onFailure(Throwable caught) {
						Window.alert(caught.getLocalizedMessage());
					}

					public void onSuccess(R result) {
						getDetailView(simpleTable, detailFeature, result);
					}
				});
			}

			public void showDetailViewForRecord(R record) {
				getDetailView(simpleTable, detailFeature, record);
			}
		};
		simpleTable.addListener(listener);

		// since we just added the feature, we must manually cause an update
		listener.recordsUpdated();

	}

	public DetailViewRequester<K, R> getRequester() {
		return requester;
	}

	private void getDetailView(final TableInternal<K, R> simpleTable, final DetailFeature<K, R> detailFeature,
			final R record) {
		VerticalPanel detailPanel = new VerticalPanel();

		final DetailViewCallback<K, R> callback = new DetailViewCallback<K, R>() {
			public void cancel(final DetailView<K, R> view) {
				simpleTable.setListView();
			}

			public void revert(final DetailView<K, R> view) {
				view.revert();
			}

			public void save(final DetailView<K, R> view) {
				view.commit();
				detailFeature.save(record, new AsyncCallback<Void>() {
					public void onFailure(Throwable caught) {
						view.saveFailed(caught);
					}

					public void onSuccess(Void result) {
						simpleTable.setListView();
						simpleTable.updateView(view.getRecord());
					}
				});
			}
		};

		// cleanup existing view
		if (currentDetailView != null)
			currentDetailView.release();

		currentDetailView = detailFeature.getView(record, callback);

		detailPanel.add(currentDetailView.getWidget());
		simpleTable.setRootWidget(detailPanel);
	}

	public void reload() {
	}
	
	public void init() {
	}


}
