package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.TableInternal;

/**
 * Manages the paging variables
 */
public final class PageFeatureImpl<K, R extends Record<K>> implements PageFeature {

	/* Properties */
	private int start;
	private int length;
	private int totalSize;
	private Listener listener;
	private int[] pageSizes = new int[] { 10, 25, 50, 100 };

	/**
	 * Constructor
	 * 
	 * @param tableInternal The internal interface for the table widget
	 */
	public PageFeatureImpl(final TableInternal<K, R> tableInternal) {
		this.length = pageSizes[0];
		tableInternal.addListener(new TableInternal.Listener<K, R>() {
			public void recordsUpdated() {
				informListener();
			}
		});
	}

	public int getStart() {
		return start;
	}

	public void setStart(int start) {
		this.start = start;
		informListener();
	}

	public int getLength() {
		return length;
	}

	public void setLength(int length) {
		this.length = length;
		informListener();
	}

	public int getTotalSize() {
		return totalSize;
	}

	public void setTotalSize(int totalSize) {
		this.totalSize = totalSize;
	}

	public int[] getPageSizes() {
		return pageSizes;
	}

	@Override
	public int getDefaultPageSize() {
	    return pageSizes[0];
	}
	
	private void informListener() {
		if (listener != null)
			listener.pagingUpdated(getStart(), getLength());
	}

	public void registerListener(Listener listener) {
		this.listener = listener;
	}
}
