/*
 * Created on Sep 9, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import java.util.Map;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeature;

/**
 * The book mark feature handler
 * 
 * @author Vijay Silva
 */
public class BookmarkFeatureHandler<K, R extends Record<K>> implements FeatureHandler {

	/* Properties */
	private final TableInternal<K, R> table;
	private final BookmarkFeature feature;

	/**
	 * Constructor
	 */
	public BookmarkFeatureHandler(TableInternal<K, R> table, BookmarkFeature feature) {
		this.table = table;
		this.feature = feature;
	}

	@Override
	public void init() {
	}

	@Override
	public void reset() {
	}

	@Override
	public Map<String, String> getAnchorTokens() {
		return null;
	}

	/*
	 * Get the table
	 */
	protected TableInternal<K, R> getTable() {
		return this.table;
	}

	/*
	 * Get the feature
	 */
	protected BookmarkFeature getFeature() {
		return this.feature;
	}
}
