package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import java.util.Map;

public interface FeatureHandler {

	/**
	 * Initialize the feature handler and the feature it maintains. Ensure that any default state
	 * required by the feature / handler is set and the view is initialized.
	 */
	void init();

	/**
	 * Reset the state of the feature maintained by the feature handler, and update the view.
	 */
	void reset();

	/**
	 * Get the anchor tokens used to maintain state required by the feature handler to support
	 * browser history when the table widget is displaying the list view
	 * 
	 * @return a map of the anchor token name and value
	 */
	Map<String, String> getAnchorTokens();
}
