package com.tandbergtv.neptune.widgettoolkit.client.component;

import java.util.Map;

import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;

/**
 * Base class that can be used to save the facilities that are provided by Neptune in the init call.
 * 
 * @author trybak
 */
public abstract class ComponentBase implements Component {
	protected EventListenerRegistry eventListenerRegistry;
	protected EventSink eventSink;
	protected ServiceLoader serviceLoader;
	protected Map<String, String> info;

	/**
	 * Initialize the component
	 */
	public void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink,
	        ServiceLoader serviceLoader, Map<String, String> info) {
		this.eventListenerRegistry = eventListenerRegistry;
		this.eventSink = eventSink;
		this.serviceLoader = serviceLoader;
		this.info = info;
	}	
}
