/*
 * Created on Sep 14, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailViewCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * The detail feature widget
 * 
 * @author Vijay Silva
 */
class DetailFeatureWidget<K, R extends Record<K>> extends Composite {

	/* State */
	private final DetailFeatureHandler<K, R> handler;
	private final R record;
	private final boolean newRecord;

	/* Widgets */
	private VerticalContainer container;
	private DetailView<K, R> detailView;

	/**
	 * Constructor
	 * 
	 * @param record The record for which the detail view is created
	 * @param isNewRecord flag indicating if this is a new record (create) or an existing record
	 *        (view / edit)
	 */
	public DetailFeatureWidget(DetailFeatureHandler<K, R> handler, R record, boolean isNewRecord) {
		this.handler = handler;
		this.record = record;
		this.newRecord = isNewRecord;
		initialize();
		initWidget(container);
	}

	/*
	 * Add a blank label widget to the container
	 */
	private void initialize() {
		container = new VerticalContainer();

		/* the callback for the view */
		DetailViewCallback<K, R> callback = new DetailViewCallback<K, R>() {
			@Override
			public void cancel(DetailView<K, R> view) {
				handleViewCancel();
			}

			@Override
			public void revert(DetailView<K, R> view) {
				handleViewRevert();
			}

			@Override
			public void save(final DetailView<K, R> view) {
				handleViewSave();
			}
		};

		/* The view */
		this.detailView = handler.getFeature().getView(record, callback);
		container.add(detailView.getWidget());
	}

	/**
	 * @return true if a new record, false otherwise
	 */
	public boolean isNewRecord() {
		return newRecord;
	}

	/**
	 * @return the record
	 */
	public R getRecord() {
		return record;
	}

	/**
	 * Get the detail view associated with this widget
	 * 
	 * @return The detail view
	 */
	public DetailView<K, R> getDetailView() {
		return this.detailView;
	}

	@Override
	protected void onUnload() {
		/* When the view is unloaded, release the view */
		detailView.release();
	}

	// ========================================================================
	// ===================== EVENT HANDLING
	// ========================================================================

	/*
	 * Handle the view cancel event
	 */
	private void handleViewCancel() {
		/* Notify the feature handler that the cancel action was performed */
		handler.handleViewCancel();
	}

	/*
	 * Handle the view save event
	 */
	private void handleViewSave() {
		detailView.commit();
		handler.getFeature().save(record, new AsyncCallback<Void>() {
			@Override
			public void onFailure(Throwable caught) {
				detailView.saveFailed(caught);
				handler.handleViewSaveFailure(caught);
			}

			@Override
			public void onSuccess(Void result) {
				handler.handleViewSaveSuccess();
			}
		});
	}

	/*
	 * Handle the view create event
	 */
	private void handleViewRevert() {
		detailView.revert();
		handler.handleViewRevert();
	}
}
