package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * This panel is displayed when the user has typed in an invalid url. e.g. If
 * the url is malformed or the user does not have permissions to view that page.
 * 
 * @author spuranik
 * 
 */
public class InvalidPagePanel extends VerticalContainer implements INeptuneWidget {
	LabelWidget label;

	public InvalidPagePanel(String label) {
		super();
		this.label = new LabelWidget(label);
		this.label.setStyleName(StyleNames.INVALID_PAGE_LABEL_STYLE);
		this.setVerticalAlignment(ALIGN_MIDDLE);
		this.add(this.label);
	}

	public void setLabel(String label) {
		this.label.setText(label);
	}
}
