/*
 * Created on May 21, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.container;

import static com.google.gwt.user.client.ui.HasHorizontalAlignment.ALIGN_CENTER;
import static com.google.gwt.user.client.ui.HasVerticalAlignment.ALIGN_MIDDLE;

import org.cobogw.gwt.user.client.ui.RoundedPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.DisclosurePanelImages;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;

/**
 * <p>
 * A decorated version of the disclosure panel which will enable the header to have rounded corners.
 * Extends DisclosureContainer which in turn extends the GWT {@link DisclosurePanel} widget.
 * </p>
 * <h3>CSS Style Rules</h3>
 * <ul>
 * <li>wtk-RoundedDisclosureContainer { the panel's primary style }</li>
 * <li>wtk-RoundedDisclosureContainer-open { dependent style set when panel is open }</li>
 * <li>wtk-RoundedDisclosureContainer-closed { dependent style set when panel is closed }</li>
 * </ul>
 * <p>
 * <img class='gallery' src='DisclosurePanel.png'/>
 * </p>
 * <p>
 * The header and content sections can be easily selected using css with a child selector:<br/>
 * .gwt-DisclosurePanel-open .header { ... }
 * </p>
 * <p>
 * The label and label-corner sections can be easily selected using css with a child selector:<br/>
 * .gwt-DisclosurePanel-open .label { ... } <br/>
 * .gwt-DisclosurePanel-open .label-corners { ... }
 * </p>
 * 
 * @see com.google.gwt.user.client.ui.DisclosurePanel
 * @author mpetrusis
 */
public class RoundedDisclosureContainer extends DisclosureContainer {

	/* Style Names */
	private static final String STYLENAME_DEFAULT = "nwt-RoundedDisclosureContainer";
	private static final String STYLENAME_LABEL_CORNERS = "label-corners";
	private static final String STYLENAME_LABEL = "label";

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String)
	 */
	public RoundedDisclosureContainer(String headerText) {
		this(headerText, false);
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String, boolean)
	 */
	public RoundedDisclosureContainer(String headerText, boolean isOpen) {
		this(createDefaultImages(), headerText, isOpen);
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(Widget)
	 */
	public RoundedDisclosureContainer(Widget header) {
		this(header, false);
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(Widget, boolean)
	 */
	public RoundedDisclosureContainer(Widget header, boolean isOpen) {
		this(createDefaultImages(), header, isOpen);
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(DisclosurePanelImages,
	 *      String, boolean)
	 */
	public RoundedDisclosureContainer(DisclosurePanelImages images, String headerText,
	        boolean isOpen) {
		this(images, new LabelWidget(headerText), isOpen);
	}

	/**
	 * Constructor
	 */
	public RoundedDisclosureContainer(DisclosurePanelImages images, Widget header, boolean isOpen) {
		super();
		initialize(header, images);
		setOpen(isOpen);
	}

	private void initialize(Widget headerWidget, DisclosurePanelImages images) {
		setStylePrimaryName(STYLENAME_DEFAULT);
		RoundedPanelHeader header = new RoundedPanelHeader(headerWidget, images);
		setHeader(header);
	}

	/*
	 * The default images to use
	 */
	private static DisclosurePanelImages createDefaultImages() {
		if (LocaleInfo.getCurrentLocale().isRTL()) {
			return GWT.create(RoundedDisclosureContainerImagesRTL.class);
		}

		return GWT.create(RoundedDisclosureContainerImages.class);
	}

	/**
	 * The header widget used for this panel
	 */
	private class RoundedPanelHeader extends Composite implements OpenHandler<DisclosureContainer>,
	        CloseHandler<DisclosureContainer> {
		private final Widget headerWidget;
		private final DisclosurePanelImages images;
		private final Image iconImage;

		private RoundedPanelHeader(Widget headerWidget, DisclosurePanelImages images) {
			this.images = images;
			this.headerWidget = headerWidget;
			this.iconImage = isOpen() ? images.disclosurePanelOpen().createImage() : images
			        .disclosurePanelClosed().createImage();

			RoundedPanel container = new RoundedPanel(RoundedPanel.ALL, 3);
			container.setCornerStyleName(STYLENAME_LABEL_CORNERS);
			initWidget(container);

			HorizontalContainer contents = new HorizontalContainer();
			container.setWidget(contents);
			contents.addStyleName(STYLENAME_LABEL);
			contents.setWidth("100%");
			contents.setSpacing(3);

			/* Add the contents */
			contents.add(this.iconImage);
			contents.add(this.headerWidget);
			contents.setCellVerticalAlignment(this.iconImage, ALIGN_MIDDLE);
			contents.setCellHorizontalAlignment(this.iconImage, ALIGN_CENTER);
			contents.setCellWidth(this.iconImage, (iconImage.getWidth() + 2) + "px");

			addOpenHandler(this);
			addCloseHandler(this);
			setStyle();
		}

		public final void onClose(CloseEvent<DisclosureContainer> event) {
			setStyle();
		}

		public final void onOpen(OpenEvent<DisclosureContainer> event) {
			setStyle();
		}

		/*
		 * Update the image
		 */
		private void setStyle() {
			if (isOpen()) {
				images.disclosurePanelOpen().applyTo(iconImage);
			} else {
				images.disclosurePanelClosed().applyTo(iconImage);
			}
		}
	}
}
