/**
 * MenuItemProxy.java
 * Created Jun 23, 2009
 * Copyright (c) Tandberg Television 2009
 */
package com.tandbergtv.neptune.widgettoolkit.client.menu;

import java.util.List;

/**
 * A virtual parent menu item. Children will eventually get attached to the "real" parent, if
 * it already exists.
 * 
 * @author Sahil Verma
 */
public class MenuItemProxy extends MenuItemBase {

	private List<MenuItemBase> items;
	
	/**
	 * Creates a proxy menu item
	 * 
	 * @param name
	 */
	public MenuItemProxy(String name, List<MenuItemBase> items) {
		super(name);
		this.items = items;
	}

	/**
	 * @return the items
	 */
	public List<MenuItemBase> getItems() {
		return items;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase#accept(com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase.Visitor)
	 */
	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}
}
