package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class FormContainer extends Composite implements INeptuneWidget {
	private static final String STYLE_CONTAINER_TABLE = "nwt-FormContainer-table";
	private static final String STYLE_LABEL_CELL = "nwt-FormContainer-label-cell";
	private static final String STYLE_VALUE_CELL = "nwt-FormContainer-value-cell";
	private static final String STYLE_REQUIRED = "nwt-FormContainer-required";
	private static final String STYLE_LABEL = "nwt-FormContainer-label";
	private static final String STYLE_VALUE = "nwt-FormContainer-value";
	private static final int MAINPANEL_SPACING = 10;

	private VerticalPanel mainPanel;
	private FlexTable formTable;
	private HorizontalPanel buttonPanel;

	public FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant buttonPanelHAlign) {
		mainPanel = new VerticalPanel();
		mainPanel.setSpacing(MAINPANEL_SPACING);
		formTable = new FlexTable();
		formTable.setStyleName(STYLE_CONTAINER_TABLE);
		buttonPanel = new HorizontalPanel();

		mainPanel.add(formTable);
		mainPanel.setCellHorizontalAlignment(formTable, VerticalPanel.ALIGN_CENTER);

		mainPanel.add(buttonPanel);
		mainPanel.setCellHorizontalAlignment(buttonPanel, buttonPanelHAlign);

		initWidget(mainPanel);
	}

	public int addRow(LabelWidget label, Widget value, boolean markRequired) {
		label.addStyleName(STYLE_LABEL);
		value.addStyleName(STYLE_VALUE);
		int lastRowIndex = formTable.getRowCount();
		if(markRequired) {
			HorizontalContainer container = new HorizontalContainer();
			LabelWidget requiredMarker = new LabelWidget("*");
			requiredMarker.setStyleName(STYLE_REQUIRED);
			container.add(requiredMarker);
			container.setCellWidth(requiredMarker, "10");
			container.add(label);
			formTable.setWidget(lastRowIndex, 0, container);
		} else {
			formTable.setWidget(lastRowIndex, 0, label);
		}
		formTable.getCellFormatter().setStyleName(lastRowIndex, 0, STYLE_LABEL_CELL);
		
		formTable.setWidget(lastRowIndex, 1, value);
		formTable.getCellFormatter().setStyleName(lastRowIndex, 1, STYLE_VALUE_CELL);
		
		return lastRowIndex;
	}

	public int addRow(LabelWidget label, Widget value) {
		return addRow(label, value, false);
	}
	
	public int addRow(String first, Widget second, boolean markRequired) {
		return addRow(new LabelWidget(first), second, markRequired);
	}

	public int addRow(String first, Widget second) {
		return addRow(first, second, false);
	}

	public void removeRow(int index) {
		formTable.removeRow(index);
	}

	public void addButton(ButtonWidget buttonWidget) {
		buttonPanel.add(buttonWidget);
	}

	public void removeButton(ButtonWidget buttonWidget) {
		buttonPanel.remove(buttonWidget);
	}
}
