/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.ejb;

import com.tandbergtv.neptune.configuration.entity.ProductInfo;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.configuration.service.IConfigurationServiceRemote;
import com.tandbergtv.neptune.configuration.service.ILifecycleConfigurationService;
import com.tandbergtv.neptune.configuration.settings.service.ISettingsService;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.util.PropertyFileReader;
import com.tandbergtv.neptune.validation.SettingValidationException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@Service(objectName="Neptune:service=com.tandbergtv.neptune.configuration.service.IConfigurationService")
@Remote(value={IConfigurationServiceRemote.class})
@Local(value={IConfigurationService.class})
public class ConfigurationService
implements ILifecycleConfigurationService,
IConfigurationService,
IConfigurationServiceRemote {
    private String confFolderLocation;
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String CONFIG_FOLDER_RELATIVE_PATH = "conf";
    private static final String PRODUCT_FILE = "product.properties";
    private static final Logger logger = Logger.getLogger(ConfigurationService.class);
    private static ProductInfo productInfo = null;
    private static Date licenseExpirationDate;
    @EJB
    private ILicenseManager licenseManager;
    @EJB
    private ISettingsService settingsService;

    @Override
    public void start() throws Exception {
        File configFolder = new File(System.getProperty(INSTALL_FOLDER_PROPERTY), CONFIG_FOLDER_RELATIVE_PATH);
        this.confFolderLocation = configFolder.getAbsolutePath();
        logger.debug((Object)("confFolderLocation=" + this.confFolderLocation));
        this.settingsService.loadSettings(this.confFolderLocation);
    }

    private void readProductInfo(String installDir) {
        File productFile = new File(installDir, PRODUCT_FILE);
        if (productFile.exists()) {
            Map properties = PropertyFileReader.readProperties((File)productFile);
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                String expirationDateStr = this.licenseManager.getProperty("expirationDate");
                if (expirationDateStr != null && !expirationDateStr.trim().isEmpty()) {
                    licenseExpirationDate = dateFormat.parse(this.licenseManager.getProperty("expirationDate"));
                }
            }
            catch (Exception e) {
                logger.error((Object)"Invalid license", (Throwable)e);
                licenseExpirationDate = new Date(0L);
            }
            productInfo = new ProductInfo(properties);
        } else {
            logger.warn((Object)("[Configuration Error] product.properties file is not present in " + productFile.getParent()));
            productInfo = new ProductInfo();
        }
        logger.info((Object)("[software version] " + this.removeHTMLTags(productInfo.getProductTitle()) + " " + productInfo.getProductVersion()));
    }

    public File getFile(String relativeFolderPath, String filename) {
        if (relativeFolderPath != null && !relativeFolderPath.equals("")) {
            File folderLocation = new File(this.confFolderLocation, relativeFolderPath);
            logger.debug((Object)("final folderLocation=" + folderLocation.getAbsolutePath()));
            return new File(folderLocation, filename);
        }
        return new File(this.confFolderLocation, filename);
    }

    public String getInstallDirectory() {
        return System.getProperty(INSTALL_FOLDER_PROPERTY);
    }

    public File getFile(String relativeFilePath) {
        return new File(this.confFolderLocation, relativeFilePath);
    }

    public ProductInfo getProductInfo() {
        this.refreshProductInfo();
        return productInfo;
    }

    private void refreshProductInfo() {
        if (productInfo == null) {
            this.readProductInfo(this.getInstallDirectory());
        }
        if (licenseExpirationDate == null) {
            productInfo.setLicenseValid(true);
        } else {
            productInfo.setLicenseValid(licenseExpirationDate.after(new Date()));
        }
    }

    private String removeHTMLTags(String str) {
        return str.replaceAll("\\<.*&?>", "");
    }

    public Map<String, String> getProperties(String settingsPath) {
        return this.settingsService.getProperties(settingsPath);
    }

    public void saveSettings(Map<String, Map<String, String>> settings) throws SettingValidationException {
        this.settingsService.saveSettings(settings);
    }

    public void saveSettings(String groupPath, Map<String, String> values) throws SettingValidationException {
        this.settingsService.saveSettings(groupPath, values);
    }

    public String getAllSettingDefinitionsAsJSON() {
        return this.settingsService.getAllSettingDefinitionsAsJSON();
    }

    public String getPropertiesAsJSON(String settingsPath) {
        return this.settingsService.getPropertiesAsJSON(settingsPath);
    }
}

