package com.tandbergtv.neptune.ui.local.client.application;

import java.util.List;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.portalpage.client.PortalPage;
import com.tandbergtv.neptune.ui.portalpage.client.PortletConfig;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;

/**
 * Factory used to create the PortalPage widget
 */
public class PortalPageFactory implements WidgetFactory {

	static PortalPage portal = null;
	
	/* State */
	private List<PortletConfig> availablePortlets;
	
	/**
	 * Constructor
	 * 
	 * @param configList The list of PortletConfig of Portlets to show in the home tab
	 */
	public PortalPageFactory(List<PortletConfig> availablePortlets) {
		this.availablePortlets = availablePortlets;
	}
	
	/**
	 * Creates a new instance of the PortalPage widget
	 * 
	 * @see com.tandbergtv.neptune.widgettoolkit.client.application.TypedWidgetFactory#getInstance()
	 */
	@Override
	public Widget getInstance() {
		if (portal == null) {
			portal = new PortalPage(availablePortlets);
		} else {
			portal.setAvailablePortlets(availablePortlets);
			portal.showWidget();
		}
		return portal;
	}

	@Override
	public void release(Widget widget) {
		((PortalPage) widget).clearWidget();
	}
	
	public void clearPortal() {
		portal.clearWidget();
	}
}

