package com.tandbergtv.neptune.ui.portalpage.client.portaluserpref;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * asynchronous callback interface to be used on the client side
 */
public interface PortalUserPreferenceServiceAsync {
	
	/**
	 * Creates a Portal User Preference based on the given parameter
	 * 
	 * @param uiPortalUserPreference the Portal User Preference
	 * @return the created Portal User Preference
	 */
	void create(UiPortalUserPreference uiPortalUserPreference, AsyncCallback<UiPortalUserPreference> callback);

	/**
	 * Creates Portal User Preferences based on the given list parameter
	 * 
	 * @param uiPortalUserPreferences the list of Portal User Preferences
	 * @return the list of created Portal User Preferences
	 */
	void create(List<UiPortalUserPreference> uiPortalUserPreferences, AsyncCallback<List<UiPortalUserPreference>> callback);

	/**
	 * Saves the given Portal User Preference
	 * 
	 * @param uiPortalUserPreference the Portal User Preference
	 * @return the saved Portal User Preference
	 */
	void save(UiPortalUserPreference uiPortalUserPreference, AsyncCallback<UiPortalUserPreference> callback);

	/**
	 * Retrieves a list of Portal User Preferences
	 * 
	 * @return the list of Portal User Preferences found
	 */
	void getPreferences(AsyncCallback<List<UiPortalUserPreference>> callback);

	/**
	 * Retrieve the Portal User Preference with the given component, type and key
	 * 
	 * @param component the component name
	 * @param key the Portal User Preference key
	 * @return the Portal User Preference found or null if not found
	 */
	void getPreference(String component, String key, AsyncCallback<UiPortalUserPreference> callback);

	/**
	 * Deletes the Portal User Preferences with the given component
	 * 
	 * @param component the component name
	 */
	void deletePreferences(String component, AsyncCallback<Void> callback);

	/**
	 * Delete the Portal User Preference with the given component and key
	 * 
	 * @param component the component name
	 * @param key the User Preference key
	 */
	void deletePreference(String component, String key, AsyncCallback<Void> callback);

	/**
	 * Update the preferences for the current user for the given component and key to be the new
	 * set of provided preferences
	 * 
	 * @param component the component name
	 * @param key the User Preference key
	 * @param preferences The preferences
	 */
	void updatePreferences(List<UiPortalUserPreference> preferences, AsyncCallback<Void> callback);

}
