package com.tandbergtv.neptune.ui.portalpage.client.ui;

import java.util.ArrayList;
import java.util.List;

import org.gwtportlets.portlet.client.WidgetFactory;
import org.gwtportlets.portlet.client.WidgetInfo;
import org.gwtportlets.portlet.client.layout.ContainerFactory;
import org.gwtportlets.portlet.client.layout.LDOM;
import org.gwtportlets.portlet.client.layout.LayoutConstraints;
import org.gwtportlets.portlet.client.layout.LayoutEvent;
import org.gwtportlets.portlet.client.layout.LayoutPerf;
import org.gwtportlets.portlet.client.layout.RowLayout;
import org.gwtportlets.portlet.client.ui.LayoutPanel;

import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.client.Element;

/*
 * Manage a given number of columns
 * where sizing for all but the last are a percentage of window width.
 * The last column grows or shrinks to fit the remaining space.
 * The last column is "hidden" by default
 *  i.e. the user can opt to stretch it and move Widgets into it
 */
public class ColumnSizingLayoutPanel extends LayoutPanel {//implements LayoutHandler {

	public static final int DEFAULT_NUM_COLUMNS = 2;
	private static final int SIDE_MARGIN = 10;
	
	private List<ColumnPanel> columns;
	private int numNonGrowColumns;

	public ColumnSizingLayoutPanel() {
		this(DEFAULT_NUM_COLUMNS);
	}
	
	public ColumnSizingLayoutPanel(int numColumns) {
		super(false);   // row container for all columns
		
        setStyleName("column-sizing-panel");
		
		numNonGrowColumns = numColumns;

		// create the columns
		columns = new ArrayList<ColumnPanel>();
		if (numColumns > 0) {
			float columnWidth = 0.9999f / numColumns;
			// add the requested number of columns
			for (int i=0; i<numColumns; i++) {
				ColumnPanel column = new ColumnPanel();
				add(column, new RowLayout.Constraints(columnWidth, 0.0f, LayoutConstraints.VISIBLE));
			}
			// add the last column ... an "extra" one that Grows			
			ColumnPanel growColumn = new ColumnPanel();
			add(growColumn, new RowLayout.Constraints(LayoutConstraints.VISIBLE));
		}
	}
	
	public int getNumNonGrowColumns() {
		return numNonGrowColumns;
	}
	
	public void addWidgetToColumn(int columnIndex, Widget widget, float constraints) {
		if (columnIndex < 0) {
			columnIndex = 0;
		} else if (columnIndex >= columns.size()) {
			columnIndex = columns.size()-1;
		}
		columns.get(columnIndex).add(widget, new RowLayout.Constraints(constraints));
	}
	
	// Assumes you know what you are doing and are not exceeding 100%
	//    when done with all columns
	public void setColumnWidth(int columnIndex, float constraints) {
		// ignore attempts to make the Grow column (last column) a percentage size!
		if (columnIndex >= 0 && columnIndex < columns.size()-1) {
			setLayoutConstraints(columns.get(columnIndex), new RowLayout.Constraints(constraints, 0.0f, LayoutConstraints.VISIBLE));
		}
	}

	@Override
	public void add(Widget widget) {
		super.add(widget);
		if (widget instanceof ColumnPanel) {
			columns.add((ColumnPanel) widget);
		}
	}

    @Override
    public void layout() {
        if (!isAttached()) {
            return;
        }
        LayoutPerf.enter(this);
        try {
            Element e = getElement();
            int width = LDOM.getContentWidth(e) - 2*SIDE_MARGIN;
            int height = LDOM.getContentHeight(e);
            ensureLayout();
            getLayout().layoutWidgets(this,
            		LDOM.getContentLeft(e)+SIDE_MARGIN, LDOM.getContentTop(e), width, height);
            LayoutEvent.fire(this);
        } finally {
            LayoutPerf.leave();
        }
    }
		
	@Override
    public WidgetFactory<ColumnSizingLayoutPanel> createWidgetFactory() {
        return new Factory(this);
    }

    @WidgetInfo(description = "Panel with preset number of columns")
    public static class Factory extends ContainerFactory<ColumnSizingLayoutPanel> {

		private static final long serialVersionUID = 1L;

		private boolean limitMaximize;
		private int numColumns = DEFAULT_NUM_COLUMNS;

        public Factory() {
        }

        public Factory(ColumnSizingLayoutPanel c) {
            super(c);
            limitMaximize = c.isLimitMaximize();
            numColumns = c.getNumNonGrowColumns();
        }

        public void refresh(ColumnSizingLayoutPanel p) {
            p.columns.clear();
            refreshSettings(p);
            super.refresh(p);
        }

        /**
         * Refresh only the configurable settings of p.
         */
        public void refreshSettings(ColumnSizingLayoutPanel p) {
            p.setLimitMaximize(limitMaximize);
        }

        public ColumnSizingLayoutPanel createWidget() {
            return new ColumnSizingLayoutPanel(numColumns);
        }
    }

}
