/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.activity;

import com.tandbergtv.neptune.usermgmt.activity.IUserActivity;
import com.tandbergtv.neptune.usermgmt.activity.UserActivityFactory;
import org.apache.log4j.Logger;

public final class UserActivityLogger {
    private static final Logger logger = Logger.getLogger(UserActivityLogger.class);
    private static UserActivityFactory factory = null;

    private UserActivityLogger() {
    }

    public static IUserActivity createUserActivity(String activityName, boolean result) {
        return UserActivityLogger.getUserActivityFactory().createUserActivity(activityName, result);
    }

    public static IUserActivity createUserActivity(String activityName, String description, boolean result) {
        return UserActivityLogger.getUserActivityFactory().createUserActivity(activityName, description, result);
    }

    public static boolean logUserActivity(IUserActivity activity) {
        try {
            UserActivityLogger.getUserActivityFactory().getUserActivityLogService().logActivity(activity);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error logging " + activity + ", error: " + e.toString()), (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean logUserActivity(String activityName, boolean result) {
        try {
            IUserActivity activity = UserActivityLogger.createUserActivity(activityName, result);
            return UserActivityLogger.logUserActivity(activity);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error logging User Activity[activityName: " + activityName + "] for current user, error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean logUserActivity(String activityName, String description, boolean result) {
        try {
            IUserActivity activity = UserActivityLogger.createUserActivity(activityName, description, result);
            return UserActivityLogger.logUserActivity(activity);
        }
        catch (RuntimeException e) {
            logger.error((Object)("Error logging User Activity[activityName: " + activityName + "] for current user, error: " + e.getLocalizedMessage()), (Throwable)e);
            return false;
        }
    }

    private static synchronized UserActivityFactory getUserActivityFactory() {
        if (factory == null) {
            factory = UserActivityFactory.getInstance();
        }
        return factory;
    }
}

