package com.tandbergtv.neptune.ui.realm.client.settings.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiComplexSetting;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingDefinition;
import com.tandbergtv.neptune.ui.realm.client.settings.service.UiSettingGroup;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.FormContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * 		Complex settings UI. Created based on metadata provided by the user.
 * 
 * @author Francisco Bento da Silva Neto
 *
 */
public class ComplexSettingsUI implements SettingsFormUI {

	private RealmConstants constants = GWT.create(RealmConstants.class);
	
	private static final String HELP_ICON = "realm/images/help.png";
	private static final String RESTART_ICON = "realm/images/restart.png";

	private static final String PATH_SEPARATOR = ".";
	
	private UiSettingGroup settingGroup;
	private Map<String, String> settingsValues;
	private List<SettingsInputWidgetWrapper> inputWidgets;
	private Map<String, RoundedDisclosureContainer> panelMap = new HashMap<String, RoundedDisclosureContainer>();
	private UiComplexSetting rootSetting;
	
	private boolean restartRequired = false;
	
	private Map<String,Integer> arrayLength = new HashMap<String, Integer>();
	
	public ComplexSettingsUI() {
	}

	public int getComplexSettingArrayLength(String path) {
		Integer length = arrayLength.get(path);
		if (length == null) {
			length = 0;
			arrayLength.put(path, length);
		}
		return arrayLength.get(path);
	}
	
	public void buildComplexSettingArrayLength() {
		for (String key : settingsValues.keySet()) {
			int i = key.indexOf("[", 0); 
			
			while (i != -1) {
				String varPath = key.substring(0, i);
				
				Integer length = arrayLength.get(varPath);
				if (length == null) {
					length = 0;
					arrayLength.put(varPath, length);
				}
				String arrayIndexStr = key.substring(i+1, key.indexOf("]", i));
				int arrayIndex = Integer.parseInt(arrayIndexStr);
				int arraySize = arrayIndex + 1;

				if (arraySize > length) {
					arrayLength.put(varPath, arraySize);
				}

				i = key.indexOf("[", i+1); 
			}

		}
	}
	
	public void incrementComplexSettingArrayLength(String path) {
		Integer length = getComplexSettingArrayLength(path);
		length++;
		arrayLength.put(path, length);
	}

	public void decrementComplexSettingArrayLength(String path) {
		Integer length = getComplexSettingArrayLength(path);
		length--;
		arrayLength.put(path, length);
	}
	
	public RoundedDisclosureContainer createGrouppedForm(UiComplexSetting parent, String path) {
			RoundedDisclosureContainer settingPanel = createSection(parent, path);
			VerticalContainer settingPanelContainer = (VerticalContainer) settingPanel.getContent();
			
			FormContainer formContainer = new FormContainer(HasHorizontalAlignment.ALIGN_LEFT);
			List<UiComplexSetting> complexSettings = new ArrayList<UiComplexSetting>();
			for (UiSettingDefinition setting : parent.getSettings()) {
				if (setting instanceof UiComplexSetting) {
					complexSettings.add((UiComplexSetting) setting);
				} else {
					String settingName = path + PATH_SEPARATOR + setting.getName();
					
					boolean showFields = true;
					
					String pathNoIndex = path;
					int braceIndex = path.lastIndexOf("[");
					if (braceIndex >= 0) {
						pathNoIndex = path.substring(0, braceIndex);
					}
					
					int length = getComplexSettingArrayLength(pathNoIndex);
					if (length == 0) {
						if (parent.getMin() == null) {
							showFields = false;
						} else {
							incrementComplexSettingArrayLength(pathNoIndex);
						}
					}
					if (parent == rootSetting) {
						showFields = true;
					}
					if (showFields) {
						HorizontalContainer fieldContainer = new HorizontalContainer();
						
						LabelWidget label = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getDisplayName()));
						
						ImageWidget helpIcon = new ImageWidget(HELP_ICON);
						helpIcon.setTitle(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
						helpIcon.addStyleName("SettingsUiHelpIcon");
						
						LabelWidget helpWidget = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
						helpWidget.addStyleName("SettingsUiHelpText");
						
						boolean isRequired = setting.getRequired();
						
						SettingsInputWidgetWrapper widgetWrapper = SettingsWidgetFactory.getWidgetFor(setting, settingsValues.get(settingName));
						fieldContainer.add(widgetWrapper.createInputWidget());
						if (setting.isRestartRequired()) {
							ImageWidget restartIcon = new ImageWidget(RESTART_ICON);
							restartIcon.setTitle(constants.settingRequiresRestart());
							restartIcon.addStyleName("SettingsUiHelpIcon");
							fieldContainer.add(restartIcon);
						}
						fieldContainer.add(helpIcon);
						fieldContainer.add(helpWidget);
						widgetWrapper.setSettingName(settingName);
		
						formContainer.addRow(label, fieldContainer.asWidget(), isRequired);
						inputWidgets.add(widgetWrapper);
					}
				}
			}
			// Form isnt empty.
			if (formContainer.getFieldCount() > 0) {
				settingPanelContainer.add(formContainer);
			}
			
			for (UiComplexSetting complexSetting : complexSettings) {
				String childPath = path + PATH_SEPARATOR + complexSetting.getName();
				
				int sectionsToCreate = 1;

				if (complexSetting.getMax() == null || complexSetting.getMax() > 1) {
					sectionsToCreate = getComplexSettingArrayLength(childPath);
					
					sectionsToCreate = Math.max(sectionsToCreate, 1);
					
					if (complexSetting.getMin() != null && complexSetting.getMin() > 1) {
						if (sectionsToCreate < complexSetting.getMin()) {
							sectionsToCreate = complexSetting.getMin();
						}
					}
				}
				
				for (int i = 0; i < sectionsToCreate; i++) {
					String childIndexedPath = childPath;
					if (complexSetting.getMax() == null || complexSetting.getMax() > 1) {
						childIndexedPath+= "[" + i + "]";
					}
					settingPanelContainer.add(createGrouppedForm(complexSetting, childIndexedPath));
				}
			}
			
			return settingPanel;
	}
	
	public Widget createRoot() {
		UiComplexSetting setting = (UiComplexSetting) settingGroup.getSettings().get(0);
		rootSetting = setting;
		
		return createGrouppedForm(setting, setting.getName());
	}
	
	private RoundedDisclosureContainer createSection(final UiComplexSetting setting,
													 final String path) {
		
		// if panel is already created, just returns it.
		if (panelMap.get(path) != null) {
			return panelMap.get(path); 
		}
		
		HorizontalContainer header = new HorizontalContainer();
		header.setWidth("100%");
		
		HorizontalContainer headerLabels = new HorizontalContainer();
		LabelWidget label = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getDisplayName()));
		headerLabels.add(label);
		
		ImageWidget helpIcon = new ImageWidget(HELP_ICON);
		helpIcon.setTitle(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
		helpIcon.addStyleName("SettingsUiHelpIcon");
		
		LabelWidget helpWidget = new LabelWidget(LocalizedSettingUtil.toLocalizedString(setting.getHelpText()));
		helpWidget.addStyleName("SettingsUiHelpText");

		if (setting.isRestartRequired()) {
			ImageWidget restartIcon = new ImageWidget(RESTART_ICON);
			restartIcon.setTitle(constants.settingRequiresRestart());
			restartIcon.addStyleName("SettingsUiHelpIcon");
			headerLabels.add(restartIcon);
		}
		headerLabels.add(helpIcon);
		headerLabels.add(helpWidget);
		
		header.add(headerLabels);

		HorizontalContainer headerButtons = new HorizontalContainer();
		
		header.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
		header.add(headerButtons);
		final RoundedDisclosureContainer complexPanel = new RoundedDisclosureContainer(header);
		complexPanel.setTitle(path);
		
		if (setting != rootSetting) {
			if (setting.getMax() == null || setting.getMax() > 1) {
				ButtonWidget add = new ButtonWidget();
				add.addStyleDependentName(StyleNames.ACT_TOWARDS_SAVE_BUTTON_STYLE);
				add.setText("+");
				headerButtons.add(add);
				
				add.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						event.stopPropagation();
						String fullPath = complexPanel.getTitle();
						String pathNoBrackets = fullPath.substring(0, fullPath.lastIndexOf("["));
						int length = getComplexSettingArrayLength(pathNoBrackets);
						if (setting.getMax() == null || setting.getMax() >= (length+1)) {
							String indexedPath = pathNoBrackets + "[" + length + "]";
							incrementComplexSettingArrayLength(pathNoBrackets);
							RoundedDisclosureContainer parentPanel = panelMap.get(getParentPath(fullPath));
							
							VerticalContainer container = (VerticalContainer) parentPanel.getContent();
							
							RoundedDisclosureContainer newGroup = createGrouppedForm(setting, indexedPath);
							int panelPosition = -1;
							for(int i = 0; i < container.getWidgetCount(); i++) {
								if (container.getWidget(i) instanceof RoundedDisclosureContainer) {
									RoundedDisclosureContainer section = (RoundedDisclosureContainer) container.getWidget(i);
									if (section.getTitle().startsWith(pathNoBrackets)) {
										panelPosition = i;										
									}
								}
							}
							if (panelPosition == -1) {
								panelPosition = container.getWidgetCount();
							}
							panelPosition++;
							if (panelPosition == container.getWidgetCount()) {
								container.add(newGroup);
							} else {
								container.add(newGroup);
								for (int i = panelPosition; i < container.getWidgetCount() - 1; i++) {
									Widget w = container.getWidget(panelPosition);
									container.remove(panelPosition);
									container.add(w);
								}
							}
						}
					}
				});
				
				ButtonWidget remove = new ButtonWidget();
				remove.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
				remove.setText("-");
				headerButtons.add(remove);
				
				remove.addClickHandler(new ClickHandler() {
					@Override
					public void onClick(ClickEvent event) {
						event.stopPropagation();

						int min = 0;
						if (setting.getMin() != null) {
							min = setting.getMin();
						}
						String fullPath = complexPanel.getTitle();
						String pathNoBrackets = fullPath.substring(0, fullPath.lastIndexOf("["));
						int size = getComplexSettingArrayLength(pathNoBrackets);
						if (size > min) {
							
							if (size == 1) {
								// is the last item. removes just the fields, keep the disclosure container for the +/- buttons.
								VerticalContainer container = (VerticalContainer) complexPanel.getContent();
								for (int i = 0; i < container.getWidgetCount(); i++) {
									container.remove(i);
								}
							} else {
								// removes the widget and its children from the parent container
								RoundedDisclosureContainer parentPanel = panelMap.get(getParentPath(fullPath));
								for (Iterator<String> i = panelMap.keySet().iterator(); i.hasNext();) {
									String key = i.next();
									if (key.startsWith(fullPath)) {
										i.remove();
									}
								}
								VerticalContainer container = (VerticalContainer) parentPanel.getContent();
								container.remove(complexPanel);
							}
							// removes the input widgets from the list
							for (Iterator<SettingsInputWidgetWrapper> i = inputWidgets.iterator(); i.hasNext();) {
								SettingsInputWidgetWrapper widget = i.next();
								if (widget.getSettingName().startsWith(fullPath)) {
									i.remove();
								}
							}
							
							String indexStr = fullPath.substring(fullPath.lastIndexOf("[") + 1, fullPath.length() - 1);
							int removedIndex = Integer.parseInt(indexStr);
							
							// rename widgets to keep the index
							Map<String, RoundedDisclosureContainer> newPanelMap = new HashMap<String, RoundedDisclosureContainer>(panelMap);
							for (SettingsInputWidgetWrapper widget : inputWidgets) {
								String widgetName = widget.getSettingName();
								int braceStartIndex = widgetName.indexOf(pathNoBrackets);
								if (braceStartIndex >= 0) {
									int braceCloseIndex = widgetName.indexOf("]", pathNoBrackets.length());
									
									String currentIndexStr = widgetName.substring(pathNoBrackets.length() + 1, braceCloseIndex);
									int currentIndex = Integer.parseInt(currentIndexStr);
									
									if (currentIndex > removedIndex) {
										String oldGroupName = pathNoBrackets + "[" + currentIndex + "]";
										currentIndex--;
										String newGroupName = pathNoBrackets + "[" + currentIndex + "]"; 
										String newSettingName = newGroupName + widgetName.substring(braceCloseIndex + 1);
										widget.setSettingName(newSettingName);										
										
										RoundedDisclosureContainer panel = panelMap.get(oldGroupName);
										if (panel != null) {
											panel.setTitle(newGroupName);
											newPanelMap.put(newGroupName, panel);
										}

									}

								}
							}
							panelMap = newPanelMap;
							
							decrementComplexSettingArrayLength(pathNoBrackets);
						}
					}
				});
			}
		}

		VerticalContainer contents = new VerticalContainer();
		contents.setWidth("100%");

		complexPanel.add(contents);
		complexPanel.setOpen(true);
		complexPanel.setWidth("100%");
		
		panelMap.put(path, complexPanel);
		
		return complexPanel;
	}
	
	protected String getParentPath(String settingPath) {
		return settingPath.substring(0, settingPath.lastIndexOf(PATH_SEPARATOR));
	}

	public Widget createUI() {
		return createRoot();
	}
	
	public void setSettingGroup(UiSettingGroup settingGroup) {
		this.settingGroup = settingGroup;
		this.inputWidgets = new ArrayList<SettingsInputWidgetWrapper>(settingGroup.getSettings().size());
	}
	
	public UiSettingGroup getSettingGroup() {
		return settingGroup;
	}

	public void setSettingsValues(Map<String, String> settingsValues) {
		this.settingsValues = settingsValues;
		buildComplexSettingArrayLength();
	}
	
	public Map<String, String> applyChanges() {
		Map<String, String> changedSettings = new HashMap<String, String>();
		for (SettingsInputWidgetWrapper input : inputWidgets) {
			changedSettings.put(input.getSettingName(), input.getValue());
		}
		
		if (rootSetting.isRestartRequired()) {
			restartRequired = !changedSettings.equals(settingsValues);
		}
		
		return changedSettings;
	}

	@Override
	public boolean requiresRestart() {
		return restartRequired;
	}
	
}
