/*

 * Created on Jul 19, 2012
 * 
 * (C) Copyright Ericsson Television Inc.
 */
package com.tandbergtv.neptune.ui.realm.client.networkelements.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.neptune.ui.realm.client.RealmUIEvents;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.UiCMSRedundancyStatus;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * A panel that has the Redundancy status plus the status description.
 * 
 * @author Francisco B. S. Neto
 */
public class RedundancyStatusPanel extends VerticalContainer implements RedundancyStatusUpdateHandler { 

	private final RealmConstants constants = GWT.create(RealmConstants.class);

	private LabelWidget redundancyStatusLabel;

	private RedundancyStatusButton redundancyStatusButton;

	protected HandlerRegistration handlerRegistration;
	
	/**
	 * Constructor. Use the default pattern for display
	 */
	public RedundancyStatusPanel() {
		super();
		
		redundancyStatusButton = new RedundancyStatusButton();
		add(redundancyStatusButton);
		
		redundancyStatusLabel = new LabelWidget();
		add(redundancyStatusLabel);
		addStyleName("portlet-table-text");
		
		hookListeners();
	}
	/**
	 * 	Hooks specific listeners used by this widget and its children.
	 * 	Used as a workaround when this widget is attached to a Portlet which doesnt 
	 * propagate calls to onUnload|onDetach events upon close or page change.
	 */
	public void hookListeners() {
		if (handlerRegistration == null) {
			handlerRegistration = RealmUIEvents.EVENT_BUS.addHandler(RedundancyStatusUpdateEvent.TYPE, this);
		}
		redundancyStatusButton.hookListeners();
	}
	
	/**
	 * 	Unhooks any specific listener used by this widget and its children.
	 * 	Used as a workaround when this widget is attached to a Portlet which doesnt 
	 * propagate calls to onUnload|onDetach events upon close or page change. 
	 */
	public void unHookListeners() {
		if (handlerRegistration != null) {
			handlerRegistration.removeHandler();
			handlerRegistration = null;
		}
		redundancyStatusButton.unHookListeners();
	}


	@Override
	protected void onUnload() {
		super.onUnload();
		unHookListeners();
	}
	
	@Override
	protected void onLoad() {
		super.onLoad();
		refreshState();
	}
	
	/**
	 * 		Forces this widget to update the current state
	 */
	public void refreshState() {
		hookListeners();
		updateStatus(RedundancyStatusStateHolder.getCurrentStatus());
		redundancyStatusButton.refreshState();
	}

	@Override
	public void onRedundancyStatusUpdate(RedundancyStatusUpdateEvent statusUpdatedEvent) {
		updateStatus(statusUpdatedEvent.getRedundancyStatus());

	}
	private void updateStatus(UiCMSRedundancyStatus redundancyStatus) {
		if (redundancyStatus == null || redundancyStatus.getAppServerClusterStatus().isDisabled()) {
			setVisible(false);
		} else {
			setVisible(true);
			
			String text = "";
			if (redundancyStatus.getAppServerClusterStatus().isFailed()
			 || redundancyStatus.getDatabaseClusterStatus().isFailed()) {
				if (redundancyStatus.getAppServerClusterStatus().isFailed() && redundancyStatus.getDatabaseClusterStatus().isFailed()) {
					text = constants.redundancyStatusFailedDescription();
				} else if (redundancyStatus.getAppServerClusterStatus().isFailed()) {
					text = constants.redundancyStatusAppServerFailedDescription();
				} else if (redundancyStatus.getDatabaseClusterStatus().isFailed()) {
					text = constants.redundancyStatusDatabaseFailedDescription();
				}
			} else if (redundancyStatus.getAppServerClusterStatus().isInactive()) {
				text = constants.redundancyStatusInactiveDescription();
			} else if (redundancyStatus.getAppServerClusterStatus().isActive()) {
				text = constants.redundancyStatusActiveDescription();
			}
			redundancyStatusLabel.setText(text);
		}
	}
}
