/*
 * Created on May 5, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.ViewAnchorChangeHandler;

/**
 * Lazy View Widget factory that maintains a singleton Lazy View widget and adds anchor management
 * support.
 * 
 * @author Vijay Silva
 */
public class LazyViewWidgetFactory implements WidgetFactory {

	private final LazyView widget;
	private final EventHandler eventHandler;
	private AnchorChangeListener anchorChangeNotifier;

	/**
	 * Constructor
	 */
	public LazyViewWidgetFactory(LazyView widget) {
		this.widget = widget;
		this.eventHandler = new EventHandler();
		widget.addViewAnchorChangeHandler(eventHandler);
	}

	/**
	 * Get the anchor change listener that the framework will use to set the widget anchor
	 * 
	 * @return The anchor change listener
	 */
	public AnchorChangeListener getAnchorChangeListener() {
		return eventHandler;
	}

	/**
	 * Get the anchor change listener that the widget will use to change the application anchor
	 * 
	 * @return the anchorChangeNotifier The anchor change notifier
	 */
	public AnchorChangeListener getAnchorChangeNotifier() {
		return anchorChangeNotifier;
	}

	/**
	 * Set the anchor change listener that the widget will use to change the application anchor
	 * 
	 * @param anchorChangeNotifier The anchor change notifier
	 */
	public void setAnchorChangeNotifier(AnchorChangeListener anchorChangeNotifier) {
		this.anchorChangeNotifier = anchorChangeNotifier;
	}

	@Override
	public LazyView getInstance() {
		return widget;
	}

	@Override
	public void release(Widget widget) {
	}

	/*
	 * Internal event handler associated with the widget maintained by the factory
	 */
	private final class EventHandler implements ViewAnchorChangeHandler, AnchorChangeListener {

		/*
		 * Called by the frame work to set the anchor on the widget
		 */
		@Override
		public void anchorChanged(String anchor) {
			widget.setAnchor(anchor);
		}

		/*
		 * Called by the widget to indicate that the widget is changing the anchor
		 */
		@Override
		public void onAnchorChange(ViewAnchorChangeEvent event) {
			if (anchorChangeNotifier != null) {
				anchorChangeNotifier.anchorChanged(event.getAnchor());
			}
		}
	}
}
