/*
 * Created on May 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link Image} widget.
 * 
 * @see com.google.gwt.user.client.ui.Image
 * @author Vijay Silva
 */
public class ImageWidget extends Image implements INeptuneWidget {

	// workaround for com.google.gwt.user.client.ui.Image issue
	//  see http://code.google.com/p/google-web-toolkit/issues/detail?id=6840
	//  JavascriptException if you try to set the Image url before it is attached...
	//  so don't set url in constructor, set it after attach
    private String url = null;
    private int height = 0;
    private int left = 0;
    private int top = 0;
    private int width = 0;
	
	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Image#Image()
	 */
	public ImageWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Image#Image(String)
	 */
	public ImageWidget(String url) {
		super();
		this.url = url;
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Image#Image(String, int, int, int, int)
	 */
	public ImageWidget(String url, int left, int top, int width, int height) {
		super();
		this.url = url;
		this.left = left;
		this.top = top;
		this.width = width;
		this.height = height;
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Image#Image(Element)
	 */
	protected ImageWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
	
	@Override
	public void onAttach() {
		super.onAttach();
		if (url != null) {
			setUrl(url);
		}
	}
	
	@Override
	public void setUrl(String url) {
		this.url = url;
		if (isAttached()) {
			if (left == 0 && top == 0 && width == 0 && height == 0) {
				super.setUrl(url);
			} else {
				super.setUrlAndVisibleRect(url, left, top, width, height);
			}
		}
	}
}
