/*
 * Created on May 21, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.container;

import java.util.Iterator;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link DisclosurePanel} widget. Since the
 * DisclosurePanel is a final class, this widget wraps the panel in a composite.
 * <p>
 * Unlike the DisclosurePanel the DisclosureContainer includes a container &gt;div&lt; which has the
 * styleName set to content to ease styling of the contents.
 * </p>
 * 
 * @see com.google.gwt.user.client.ui.DisclosurePanel
 * @author Vijay Silva
 */
public class DisclosureContainer extends Composite implements HasOpenHandlers<DisclosureContainer>,
        HasCloseHandlers<DisclosureContainer>, HasWidgets, HasAnimation, INeptuneWidget {

	/* The panel */
	private DisclosurePanel panel;

	private SimplePanel contentWrapper;

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel()
	 */
	public DisclosureContainer() {
		this.panel = new DisclosurePanel();
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String)
	 */
	public DisclosureContainer(String headerText) {
		this.panel = new DisclosurePanel(headerText);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(ImageResource,
	 *      ImageResource, String)
	 */
	public DisclosureContainer(ImageResource openImage, ImageResource closedImage, String headerText) {
		this.panel = new DisclosurePanel(openImage, closedImage, headerText);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
		EventDelegator delegator = new EventDelegator();
		this.panel.addOpenHandler(delegator);
		this.panel.addCloseHandler(delegator);

		this.contentWrapper = new SimplePanel();
		this.panel.setContent(contentWrapper);

		this.initWidget(panel);
	}

	// ========================================================================
	// ===================== EVENT HANDLING
	// ========================================================================

	@Override
	public HandlerRegistration addOpenHandler(OpenHandler<DisclosureContainer> handler) {
		return addHandler(handler, OpenEvent.getType());
	}

	@Override
	public HandlerRegistration addCloseHandler(CloseHandler<DisclosureContainer> handler) {
		return addHandler(handler, CloseEvent.getType());
	}

	// ========================================================================
	// ===================== HAS WIDGETS
	// ========================================================================

	@Override
	public void add(Widget w) {
		if (getContent() != null) {
			throw new IllegalStateException("DisclosureContainer can only contain one child widget");
		}
		this.contentWrapper.add(w);
	}

	@Override
	public boolean remove(Widget w) {
		return this.contentWrapper.remove(w);
	}

	@Override
	public void clear() {
		this.contentWrapper.clear();
	}

	@Override
	public Iterator<Widget> iterator() {
		return this.contentWrapper.iterator();
	}

	// ========================================================================
	// ===================== HAS ANIMATION
	// ========================================================================

	@Override
	public boolean isAnimationEnabled() {
		return this.panel.isAnimationEnabled();
	}

	@Override
	public void setAnimationEnabled(boolean enable) {
		this.panel.setAnimationEnabled(enable);
	}

	// ========================================================================
	// ===================== DISCLOSURE PANEL METHODS
	// ========================================================================

	/**
	 * @see DisclosurePanel#getContent()
	 */
	public Widget getContent() {
		return this.contentWrapper.getWidget();
	}

	/**
	 * @see DisclosurePanel#getHeader()
	 */
	public Widget getHeader() {
		return this.panel.getHeader();
	}

	/**
	 * @see DisclosurePanel#getHeaderTextAccessor()
	 */
	public HasText getHeaderTextAccessor() {
		return this.panel.getHeaderTextAccessor();
	}

	/**
	 * @see DisclosurePanel#isOpen()
	 */
	public boolean isOpen() {
		return this.panel.isOpen();
	}

	/**
	 * @see DisclosurePanel#setContent(Widget)
	 */
	public void setContent(Widget content) {
		this.contentWrapper.setWidget(content);
	}

	/**
	 * @see DisclosurePanel#setHeader(Widget)
	 */
	public void setHeader(Widget headerWidget) {
		this.panel.setHeader(headerWidget);
	}

	/**
	 * @see DisclosurePanel#setOpen(boolean)
	 */
	public void setOpen(boolean isOpen) {
		this.panel.setOpen(isOpen);
	}

	/*
	 * Internal class that delegates the events fired by the contained panel
	 */
	private final class EventDelegator implements OpenHandler<DisclosurePanel>,
	        CloseHandler<DisclosurePanel> {

		@Override
		public void onOpen(OpenEvent<DisclosurePanel> event) {
			delegateEvent(DisclosureContainer.this, event);
		}

		@Override
		public void onClose(CloseEvent<DisclosurePanel> event) {
			delegateEvent(DisclosureContainer.this, event);
		}
	}
}
