/*
 * Created on May 16, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link Image} widget.
 * 
 * @see com.google.gwt.user.client.ui.Image
 * @author Vijay Silva
 */
public class ImageWidget extends Image implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Image#Image()
	 */
	public ImageWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Image#Image(String)
	 */
	public ImageWidget(String url) {
		super(url);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Image#Image(String, int, int, int, int)
	 */
	public ImageWidget(String url, int left, int top, int width, int height) {
		super(url, left, top, width, height);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Image#Image(Element)
	 */
	protected ImageWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}
}
