package com.tandbergtv.neptune.widgettoolkit.client.application;

import java.util.List;

/**
 * Provides a facility for a component to query the implementation for a particular interface from
 * all other components. Very similar to java.util.ServiceLoader, minus the need to declare
 * implementations in text files.
 * 
 * @author trybak
 */
public interface ServiceLoader {

	/**
	 * Loads all service providers of matching type
	 * 
	 * @param <E> The service type
	 * @param clazz The service type class
	 * @return The list of services matching the service type
	 */
	<E extends Service> List<E> loadServices(Class<E> clazz);
}
