/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.licensing;

import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.licensing.EncryptionUtil;
import com.tandbergtv.neptune.licensing.ILicenseManager;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.licensing.LicenseUtil;
import com.tandbergtv.neptune.licensing.elim.CapacityKey;
import com.tandbergtv.neptune.licensing.elim.FeatureKey;
import com.tandbergtv.neptune.util.InjectionUtil;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.Local;
import javax.ejb.Stateless;
import org.apache.log4j.Logger;

@Local(value={ILicenseManager.class})
@Stateless
public class LicenseManager
implements ILicenseManager {
    private static final String WORKFLOW_DIR = "workflow";
    private static final String ENCRYPTED_FILE_NAME = "licensekey.lic";
    private static final String PASSWORD = "TandbergTelevisionPartOfTheEricssonGroup";
    private static final Logger logger = Logger.getLogger(LicenseManager.class);
    private static final String ELIM_LICENSE_FILE_NAME = "license.xml";
    private static final String EMPTY_STRING = "";
    private static final Properties defaults;
    private static Properties licProps;
    private static long lastModTime;
    private static long lastCheck;

    public Properties getProperties() throws InvalidLicenseException {
        IConfigurationService configReaderService = (IConfigurationService)InjectionUtil.injectInstance((String)"cms/ConfigurationService/local", IConfigurationService.class);
        File file = configReaderService.getFile(WORKFLOW_DIR, ELIM_LICENSE_FILE_NAME);
        if (file.exists()) {
            logger.debug((Object)("ELIM license file present: " + file.getPath()));
            return this.getElimLicProperties(file);
        }
        file = configReaderService.getFile(WORKFLOW_DIR, ENCRYPTED_FILE_NAME);
        return this.getPropertiesInternal(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getElimLicProperties(File file) throws InvalidLicenseException {
        if (!file.exists()) {
            logger.error((Object)("[Configuration Error] license.xml " + file.getAbsolutePath() + " license file not found"));
            throw new InvalidLicenseException("License file not found");
        }
        if (System.currentTimeMillis() - lastCheck > 60000L) {
            if (file.lastModified() > lastModTime) {
                LicenseManager.updateProperties(file);
            } else {
                lastCheck = System.currentTimeMillis();
            }
        }
        Properties properties = licProps;
        synchronized (properties) {
            return (Properties)licProps.clone();
        }
    }

    protected Properties getPropertiesInternal(File file) throws InvalidLicenseException {
        if (!file.exists()) {
            logger.error((Object)("[Configuration Error] licensekey.lic " + file.getAbsolutePath() + " license file not found"));
            throw new InvalidLicenseException("License file not found");
        }
        String encrLicenseFilePath = file.getAbsolutePath();
        EncryptionUtil encUtil = new EncryptionUtil();
        InputStream cis = encUtil.getEncryptedInputStream(PASSWORD, encrLicenseFilePath);
        Properties prop = new Properties();
        try {
            prop.loadFromXML(cis);
        }
        catch (Exception e) {
            throw new InvalidLicenseException("Could not read properties from the encrypted input stream", (Throwable)e);
        }
        return prop;
    }

    public Properties getProperties(File parentFolder) throws InvalidLicenseException {
        File workflowDir = new File(parentFolder, WORKFLOW_DIR);
        File licenseFile = new File(workflowDir, ENCRYPTED_FILE_NAME);
        return this.getPropertiesInternal(licenseFile);
    }

    public String getProperty(String key) throws InvalidLicenseException {
        return this.getProperties().getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void updateProperties(File file) throws InvalidLicenseException {
        if (System.currentTimeMillis() - lastCheck > 60000L && file.lastModified() > lastModTime) {
            logger.debug((Object)("Found new ELIM license file " + file.getPath()));
            LicenseUtil licenseUtil = null;
            try {
                licenseUtil = new LicenseUtil(file);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
            }
            if (!licenseUtil.validateLicense()) {
                throw new InvalidLicenseException("License file not valid");
            }
            Properties licPropsUpdate = new Properties();
            GregorianCalendar c = new GregorianCalendar();
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            List<FeatureKey> featureKeys = licenseUtil.getFeatureKeys();
            for (FeatureKey key : featureKeys) {
                if (key.getStartDate().before(c.getTime()) && (key.getNoStop() || key.getStopDate().after(c.getTime()))) {
                    logger.info((Object)("License Feature key [" + key.getId() + "(" + key.getDesc() + ")] is valid"));
                } else {
                    logger.warn((Object)("License Feature key [" + key.getId() + "(" + key.getDesc() + ")] is NOT valid"));
                }
                logger.info((Object)("Adding Feature key " + key.getId() + ", value = " + EMPTY_STRING));
                licPropsUpdate.setProperty(key.getId(), EMPTY_STRING);
            }
            List<CapacityKey> capacityKeys = licenseUtil.getCapacityKeys();
            for (CapacityKey key : capacityKeys) {
                if (key.getStartDate().before(c.getTime()) && (key.getNoStop() || key.getStopDate().after(c.getTime()))) {
                    logger.info((Object)("License Capacity key [" + key.getId() + "(" + key.getDesc() + ")] is valid"));
                } else {
                    logger.warn((Object)("License Capacity key [" + key.getId() + "(" + key.getDesc() + ")] is NOT valid"));
                }
                logger.info((Object)("Adding capacity key " + key.getId() + ", value = " + String.valueOf(key.getCapacity())));
                licPropsUpdate.setProperty(key.getId(), String.valueOf(key.getCapacity()));
            }
            licPropsUpdate.putAll((Map<?, ?>)defaults);
            StringWriter writer = new StringWriter();
            licPropsUpdate.list(new PrintWriter(writer));
            logger.debug((Object)("ELIM License " + writer.getBuffer().toString()));
            Properties properties = licProps;
            synchronized (properties) {
                licProps = licPropsUpdate;
            }
            lastModTime = file.lastModified();
            lastCheck = System.currentTimeMillis();
            logger.info((Object)("New ELIM license file " + file.getPath() + " ingest completed"));
        }
    }

    private static Properties defaults() {
        Properties result = new Properties();
        result.put("SiteID", EMPTY_STRING);
        result.put("expirationDate", EMPTY_STRING);
        result.put("templates", EMPTY_STRING);
        result.put("resourceTypes", EMPTY_STRING);
        result.put("systemResources", EMPTY_STRING);
        result.put("humanResources", EMPTY_STRING);
        result.put("seatLicense", EMPTY_STRING);
        result.put("PMMLicense", "true");
        result.put("EditImageLicense", "true");
        result.put("VideoPreviewLicense", "true");
        result.put("Sites.DistributionSite.MaxCount", EMPTY_STRING);
        result.put("Sites.TrackingSite.MaxCount", EMPTY_STRING);
        result.put("ProviderPortalLicense", "true");
        result.put("MetadataFormats.MaxCount", EMPTY_STRING);
        result.put("SchedulerLicense", "true");
        result.put("ContractMgrLicense", "true");
        result.put("CategoryManagerLicense", "true");
        result.put("TSTVLicense", "false");
        result.put("IsRCSOnly", "false");
        result.put("RCS.MaxRms", EMPTY_STRING);
        result.put("MetadataEnhancementLicense", "true");
        result.put("EPGManagerLicense", "true");
        result.put("HALicense", "true");
        result.put("DistOnly", "false");
        return result;
    }

    static {
        licProps = defaults = LicenseManager.defaults();
        lastModTime = 0L;
        lastCheck = 0L;
    }
}

