/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.licensing;

import com.tandbergtv.neptune.licensing.CertificateUtil;
import com.tandbergtv.neptune.licensing.InvalidLicenseException;
import com.tandbergtv.neptune.licensing.LicenseType;
import com.tandbergtv.neptune.licensing.elim.CapacityKey;
import com.tandbergtv.neptune.licensing.elim.ELIMLicense;
import com.tandbergtv.neptune.licensing.elim.FeatureKey;
import com.tandbergtv.neptune.licensing.elim.Fingerprint;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public class LicenseUtil {
    public static final String ELIM_CMS_PRODUCT_TYPE = "CMS";
    public static final String DEV_PRINT = "00000000";
    public static final String LAB_PRINT = "11111111";
    private static final Logger logger = Logger.getLogger(LicenseUtil.class);
    private ELIMLicense elimLicXml = null;

    public LicenseUtil(File licenseFile) throws Exception {
        this.elimLicXml = new ELIMLicense(licenseFile);
    }

    public LicenseUtil(String licensePath) throws Exception {
        this.elimLicXml = new ELIMLicense(new File(licensePath));
    }

    public void validateLicenseSchema(String xsdPath) throws Exception {
        this.elimLicXml.validate(xsdPath);
    }

    public List<CapacityKey> getCapacityKeys() {
        return this.elimLicXml.getCapacityKeys();
    }

    public List<FeatureKey> getFeatureKeys() {
        return this.elimLicXml.getFeatureKeys();
    }

    public static boolean validateKeyId(String id) {
        boolean valid = false;
        valid = id.matches("[A-Za-z0-9/]{1,18}");
        return valid;
    }

    public boolean validateLicense() throws InvalidLicenseException {
        return this.validateLicense(this.elimLicXml);
    }

    public boolean validateLicense(ELIMLicense elimLicXml) throws InvalidLicenseException {
        boolean valid = true;
        logger.debug((Object)"CMS product license found, validating license..");
        CertificateUtil certUtil = new CertificateUtil();
        String pkiSig = elimLicXml.getPKISignature();
        if (pkiSig == null) {
            throw new InvalidLicenseException("License file not valid: No signature");
        }
        try {
            logger.debug((Object)"Validating license signature...");
            valid = this.validateSignature(pkiSig, certUtil.buildCertificate(elimLicXml.getProdCert()), elimLicXml.getBody());
            if (!valid) {
                throw new InvalidLicenseException("License file not valid: Signature validation failed");
            }
            logger.debug((Object)"License signature is valid");
            logger.debug((Object)"Validating license certificate chain...");
            valid = certUtil.validateCertificateChain(this.getLicenseType(), elimLicXml);
            if (valid) {
                logger.debug((Object)"License certificate chain is valid");
            }
        }
        catch (InvalidKeyException e) {
            logger.error((Object)("Caught InvalidKeyException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Object)("Caught NoSuchAlgorithmException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        catch (SignatureException e) {
            logger.error((Object)("Caught SignatureException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        catch (CertificateException e) {
            logger.error((Object)("Caught CertificateException : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("Caught Exception : " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new InvalidLicenseException("License file not valid: " + e.getMessage(), (Throwable)e);
        }
        return valid;
    }

    private boolean validateSignature(String pkiSig, X509Certificate prodCert, String body) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        boolean validSig = false;
        String algorithm = prodCert.getSigAlgName();
        Signature sig = Signature.getInstance(algorithm);
        sig.initVerify(prodCert.getPublicKey());
        byte[] xmlBodyArr = this.stripWhitespace(body);
        sig.update(xmlBodyArr);
        validSig = sig.verify(DatatypeConverter.parseBase64Binary((String)pkiSig));
        return validSig;
    }

    private byte[] stripWhitespace(String str) {
        ByteArrayOutputStream byteList = new ByteArrayOutputStream();
        if (str != null) {
            for (byte curByte : str.getBytes()) {
                if (curByte <= 32) continue;
                byteList.write(curByte);
            }
        }
        return byteList.toByteArray();
    }

    public LicenseType getLicenseType() {
        Fingerprint fingerprint;
        LicenseType licenseType = LicenseType.PRODUCTION;
        if (this.elimLicXml != null && (fingerprint = this.elimLicXml.getFingerprint()) != null) {
            String print = fingerprint.getPrint();
            if (DEV_PRINT.equals(print)) {
                licenseType = LicenseType.DEV;
            } else if (LAB_PRINT.equals(print)) {
                licenseType = LicenseType.LAB;
            }
        }
        return licenseType;
    }
}

